/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.gendoc;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import net.edgemind.ibee.util.file.FileUtil;

public class Item {
    private String title;
    private String id;
    private StringBuffer content = new StringBuffer();
    private String lang;
    private String format;
    private Item parent = null;
    private String namespace = "";
    private List<Item> childs = new ArrayList<Item>();
    private Properties properties = new Properties();
    private Set<String> tags = new HashSet<String>();
    private boolean standalone;
    private boolean ignored;

    public boolean isStandalone() {
        return this.standalone;
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public Item getParent() {
        return this.parent;
    }

    public void setParent(Item parent) {
        this.parent = parent;
    }

    public List<Item> getChilds() {
        return this.childs.stream().filter(item -> !item.isIgnored()).collect(Collectors.toList());
    }

    public void setChilds(List<Item> childs) {
        this.childs = childs;
    }

    public void addChild(Item item) {
        this.childs.add(item);
        item.setParent(this);
    }

    public Item getChild(String id) {
        Optional<Item> optItem = this.childs.stream().filter(item -> item.getId().equalsIgnoreCase(id)).findFirst();
        return optItem.isPresent() ? optItem.get() : null;
    }

    public boolean hasChild(String id) {
        return this.getChild(id) != null;
    }

    public String getTitle() {
        if (this.title == null) {
            return "";
        }
        return this.title;
    }

    public void setTitle(String name) {
        if (name == null) {
            name = "";
        }
        this.title = name;
    }

    public String getId() {
        return this.id;
    }

    public String getQid() {
        StringBuffer buf = new StringBuffer();
        Item item = this;
        while (item != null) {
            if (buf.length() > 0) {
                buf.insert(0, "/");
            }
            buf.insert(0, item.getId());
            if (item.hasTag("export") || item.isStandalone()) break;
            item = item.getParent();
        }
        return buf.toString();
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getContent() {
        return this.content.toString();
    }

    public void setContent(String value) {
        this.content = new StringBuffer();
        this.content.append(value);
    }

    public void appendContent(String value) {
        this.content.append(value);
    }

    public void println(String line) {
        this.appendContent(line + FileUtil.lineSeparator());
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public int getLevel() {
        int level = 1;
        Item item = this;
        while (item.getParent() != null) {
            item = item.getParent();
            ++level;
        }
        return level;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public void removeTag(String tag) {
        this.tags.remove(tag);
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.getNamespace(false);
    }

    public String getNamespace(boolean inherit) {
        if (inherit && this.namespace == null && this.parent != null) {
            return this.parent.getNamespace(inherit);
        }
        return this.namespace != null ? this.namespace : "";
    }

    public void setIgnored(boolean value) {
        this.ignored = value;
    }
}

