/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.gendoc;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.edgemind.ibee.gendoc.Item;

public class ItemRepo {
    private List<Item> items = new ArrayList<Item>();

    public List<Item> getItems() {
        return this.items.stream().filter(item -> !item.isIgnored()).collect(Collectors.toList());
    }

    public List<Item> getItems(String namespace) {
        return this.items.stream().filter(item -> item.getNamespace().equalsIgnoreCase(namespace)).collect(Collectors.toList());
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public void addItem(Item item) {
        this.items.add(item);
    }

    public List<Item> getAllItems() {
        ArrayList<Item> allItems = new ArrayList<Item>();
        for (Item child : this.getItems()) {
            this.getAllItems(child, allItems);
        }
        return allItems;
    }

    private void getAllItems(Item item, List<Item> res) {
        res.add(item);
        for (Item child : item.getChilds()) {
            this.getAllItems(child, res);
        }
    }

    public List<Item> findItems(String itemIdPattern, String nsPattern) {
        if (nsPattern == null || nsPattern.isEmpty()) {
            nsPattern = "*";
        }
        itemIdPattern = itemIdPattern.replaceAll("\\*", ".*");
        nsPattern = nsPattern.replaceAll("\\*", ".*");
        ArrayList<Item> res = new ArrayList<Item>();
        for (Item item : this.getAllItems()) {
            String qid = item.getQid();
            if (!Pattern.matches(nsPattern.toLowerCase(), item.getNamespace(true)) || !Pattern.matches(itemIdPattern.toLowerCase(), qid.toLowerCase())) continue;
            res.add(item);
        }
        return res;
    }

    public Item findItem(String itemId) {
        return this.findItem(itemId, null);
    }

    public Item findItem(String itemIdPattern, String nsPattern) {
        if (nsPattern == null || nsPattern.isEmpty()) {
            nsPattern = "*";
        }
        nsPattern = nsPattern.replaceAll("\\*", ".*");
        itemIdPattern = itemIdPattern.replaceAll("\\*", ".*");
        for (Item item : this.getAllItems()) {
            String qid = item.getQid();
            if (!Pattern.matches(nsPattern.toLowerCase(), item.getNamespace(true)) || !Pattern.matches(itemIdPattern.toLowerCase(), qid.toLowerCase())) continue;
            return item;
        }
        return null;
    }

    public void printIds() {
        for (Item item : this.getAllItems()) {
            System.out.println(item.getNamespace(true) + "." + item.getId());
        }
    }
}

