/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.gendoc.html;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import net.edgemind.ibee.gendoc.DocUtil;
import net.edgemind.ibee.gendoc.Item;
import net.edgemind.ibee.gendoc.ItemRepo;
import net.edgemind.ibee.gendoc.LogUtil;
import net.edgemind.ibee.gendoc.ToEMConverter;
import net.edgemind.ibee.gendoc.common.DirReplication;
import net.edgemind.ibee.gendoc.common.Replication;
import net.edgemind.ibee.gendoc.html.EMToHtmlConverter;
import net.edgemind.ibee.gendoc.html.HtmlGeneratorConfig;
import net.edgemind.ibee.util.file.FileUtil;

public class HtmlGenerator {
    private ItemRepo repo;
    private File baseDir;
    private HtmlGeneratorConfig genCfg;
    private HtmlGeneratorConfig.AutoGeneration autoGen;

    public HtmlGenerator(ItemRepo repo) {
        this.repo = repo;
    }

    public void generate(HtmlGeneratorConfig genCfg) throws IOException {
        this.genCfg = genCfg;
        this.baseDir = genCfg.getOutDir();
        if (!this.baseDir.exists()) {
            FileUtil.createDir((File)this.baseDir);
        }
        this.autoGen = genCfg.getAutoGeneration();
        for (HtmlGeneratorConfig.ItemConfig itemCfg : genCfg.getItemConfigs()) {
            String id = itemCfg.getId();
            Item item = this.repo.findItem(id);
            if (item == null) {
                throw new RuntimeException("HTML GEN: No Item ID='" + id + "' found.");
            }
            Object filename = itemCfg.getFile();
            if (filename == null) {
                filename = itemCfg.getId() + ".html";
            }
            File html = new File(this.baseDir, (String)filename);
            Throwable throwable = null;
            Object var9_10 = null;
            try (BufferedWriter writer = FileUtil.openWriter((File)html, (Charset)Charset.defaultCharset());){
                this.generate(item, itemCfg, writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        if (this.autoGen != null) {
            this.generateAuto(this.autoGen);
        }
        this.replicateFiles();
    }

    private void generateAuto(HtmlGeneratorConfig.AutoGeneration autoGen) throws IOException {
        for (Item item : this.repo.getAllItems()) {
            if (!autoGen.getLevels().contains(item.getLevel()) || !this.checkNamespace(item, autoGen)) continue;
            HtmlGeneratorConfig.ItemConfig itemCfg = new HtmlGeneratorConfig.ItemConfig();
            for (String cssFile : autoGen.getCssFiles()) {
                itemCfg.addCssFile(cssFile);
            }
            String id = item.getQid();
            id = DocUtil.normalizeId(id);
            itemCfg.setId(id);
            File html = this.getHtmlFile(item);
            itemCfg.setRecursive(autoGen.isRecursive());
            itemCfg.setTitle(this.getHtmlTitle(item));
            LogUtil.log(String.format("Generate File %s", html.getAbsolutePath()));
            Throwable throwable = null;
            Object var8_9 = null;
            try (BufferedWriter writer = FileUtil.openWriter((File)html, (Charset)Charset.defaultCharset());){
                this.generate(item, itemCfg, writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private boolean checkNamespace(Item item, HtmlGeneratorConfig.AutoGeneration autoGen) {
        String requiredNs = autoGen.getNamespace();
        return DocUtil.checkNamespace(item, requiredNs);
    }

    private void generate(Item item, HtmlGeneratorConfig.ItemConfig cfg, Writer writer) throws IOException {
        this.tagOpen("html", writer);
        this.tagOpen("head", writer);
        this.writeln("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>", writer);
        this.tagOpen("style", writer);
        this.writeln("body {margin-left:20px, margin-right:20px", writer);
        this.writeln("pre {display:inline-block;}", writer);
        this.tagClose("style", writer);
        for (String cssFile : cfg.getCssFiles()) {
            this.writeln("<link rel=\"stylesheet\" href=\"" + cssFile + "\">", writer);
        }
        this.tagClose("head", writer);
        this.tagOpen("body", writer);
        this.tag("h2", cfg.getTitle(), writer);
        this.createSubChapters(item, writer);
        String content = this.getHtmlContent(item);
        this.tag("div", content, writer);
        if (cfg.isRecursive()) {
            for (Item child : item.getChilds()) {
                if (this.autoGen != null && (!this.autoGen.isRecursive() || this.autoGen.getLevels().contains(child.getLevel()))) continue;
                this.generateChilds(child, writer);
            }
        }
        this.tagClose("body", writer);
        this.tagClose("html", writer);
    }

    private File getHtmlFile(Item item) {
        String id = item.getQid();
        id = DocUtil.normalizeId(id);
        String href = id + ".html";
        return new File(this.baseDir, href);
    }

    private void createSubChapters(Item item, Writer writer) throws IOException {
        ArrayList<Item> childItems = new ArrayList<Item>();
        block0: for (Item child : item.getChilds()) {
            if (this.autoGen != null && this.autoGen.isRecursive() && this.autoGen.getLevels().contains(child.getLevel())) {
                childItems.add(child);
                continue;
            }
            for (HtmlGeneratorConfig.ItemConfig cfg : this.genCfg.getItemConfigs()) {
                String id = cfg.getId();
                Item test = this.repo.findItem(id);
                if (test != child) continue;
                childItems.add(child);
                continue block0;
            }
        }
        for (Item child : childItems) {
            File html = this.getHtmlFile(child);
            this.tagOpen("div", writer);
            this.writeln("<a href=\"" + html.getName() + "\">", writer);
            this.writeln(this.getHtmlTitle(child), writer);
            this.writeln("</a>", writer);
            this.tagClose("div", writer);
        }
    }

    private void generateChilds(Item item, Writer writer) throws IOException {
        this.tag("h3", item.getTitle(), "id", item.getId(), writer);
        String content = this.getHtmlContent(item);
        if (!content.isEmpty()) {
            this.tag("div", content, writer);
        }
        for (Item child : item.getChilds()) {
            this.generateChilds(child, writer);
        }
    }

    private String getHtmlContent(Item item) {
        ToEMConverter converter1 = new ToEMConverter();
        String emContent = converter1.convertContent(item);
        EMToHtmlConverter converter2 = new EMToHtmlConverter();
        return converter2.convert(emContent);
    }

    private String getHtmlTitle(Item item) {
        ToEMConverter converter1 = new ToEMConverter();
        String emContent = converter1.convertTitle(item);
        if (emContent == null) {
            return "";
        }
        EMToHtmlConverter converter2 = new EMToHtmlConverter();
        return converter2.convert(emContent);
    }

    private void replicateFiles() throws IOException {
        for (Replication repl : this.genCfg.getReplications()) {
            if (!(repl instanceof DirReplication)) continue;
            DirReplication dirRepl = (DirReplication)repl;
            this.replicateDir(dirRepl.getFrom(), dirRepl.getTo());
        }
    }

    private void replicateDir(File from, File to) throws IOException {
        if (FileUtil.copyFileOrDir((String)from.getAbsolutePath(), (String)to.getAbsolutePath())) {
            LogUtil.log(String.format("Copy %s to %s", from.getAbsolutePath(), to.getAbsolutePath()));
        } else {
            LogUtil.log(String.format("Error: Copy %s to %s", from.getAbsolutePath(), to.getAbsolutePath()));
        }
    }

    private void tagOpen(String tag, Writer writer) throws IOException {
        this.tagOpen(tag, null, writer);
    }

    private void tagOpen(String tag, Map<String, String> attr, Writer writer) throws IOException {
        this.write("<" + tag, writer);
        if (attr != null) {
            for (String key : attr.keySet()) {
                String value = attr.get(key);
                this.write(String.format(" %s=\"%s\"", key, value), writer);
            }
        }
        this.writeln(">", writer);
    }

    private void tagClose(String tag, Writer writer) throws IOException {
        this.writeln("</" + tag + ">", writer);
    }

    private void tag(String tag, String content, Writer writer) throws IOException {
        this.tag(tag, content, null, writer);
    }

    private void tag(String tag, String content, String key, String value, Writer writer) throws IOException {
        this.tag(tag, content, Map.of(key, value), writer);
    }

    private void tag(String tag, String content, Map<String, String> attr, Writer writer) throws IOException {
        this.tagOpen(tag, attr, writer);
        this.writeln(content, writer);
        this.tagClose(tag, writer);
    }

    private void writeln(String s, Writer writer) throws IOException {
        this.write(s + "\n", writer);
    }

    private void write(String s, Writer writer) throws IOException {
        writer.append(s);
    }
}

