/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.gendoc.image;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import net.edgemind.ibee.gendoc.LogUtil;
import net.edgemind.ibee.gendoc.image.ImageGeneratorConfig;
import net.edgemind.ibee.gendoc.pdf.StreamReader;
import net.edgemind.ibee.util.file.FileUtil;
import net.edgemind.ibee.util.system.EnvUtil;
import net.edgemind.ibee.util.system.SystemUtil;

public class ImageGenerator {
    Writer writer;
    ImageGeneratorConfig genCfg;

    public void generate(ImageGeneratorConfig genCfg) throws IOException, InterruptedException {
        this.genCfg = genCfg;
        for (String inputType : genCfg.getInputTypes()) {
            if (inputType.equalsIgnoreCase("odg")) {
                this.generateOdgImages();
                continue;
            }
            if (inputType.equalsIgnoreCase("drawio")) {
                this.generateDrawIoImages();
                continue;
            }
            throw new RuntimeException(String.format("Invalid image generation input type %s", inputType));
        }
    }

    private void generateOdgImages() throws IOException {
        List drawIoFiles = FileUtil.findFiles((File)this.genCfg.getImgFolder(), (boolean)true, f -> "odg".equalsIgnoreCase(FileUtil.getExtension((File)f)));
        for (File drawIoFile : drawIoFiles) {
            this.generateOdgImage(drawIoFile);
        }
    }

    private void generateDrawIoImages() throws IOException {
        List drawIoFiles = FileUtil.findFiles((File)this.genCfg.getImgFolder(), (boolean)true, f -> "drawio".equalsIgnoreCase(FileUtil.getExtension((File)f)));
        for (File drawIoFile : drawIoFiles) {
            this.generateDrawIoImage(drawIoFile);
        }
    }

    private void generateDrawIoImage(File drawIoFile) throws IOException {
        for (String outType : this.genCfg.getOutputTypes()) {
            File outputFile = FileUtil.replaceExtension((File)drawIoFile, (String)outType);
            String cmd = String.format("\"%s\" --export --format %s --output \"%s\" \"%s\" --crop --disable-gpu --headless --no-sandbox", this.getDrawIoExecutable(), outType, outputFile.getAbsolutePath(), drawIoFile.getAbsoluteFile());
            this.executeCommand(cmd);
        }
    }

    private void generateOdgImage(File odgFile) throws IOException {
        for (String outType : this.genCfg.getOutputTypes()) {
            File outputDir = odgFile.getParentFile();
            String cmd = String.format("\"%s\" --headless --convert-to %s --outdir \"%s\" \"%s\"", this.getLibreOfficexecutable(), outType, outputDir, odgFile.getAbsoluteFile());
            this.executeCommand(cmd);
        }
    }

    private String getDrawIoExecutable() {
        String defValue = SystemUtil.isWindows() ? "draw.io.exe" : "drawio";
        return this.getBinPath("drawio", defValue);
    }

    private String getLibreOfficexecutable() {
        String defValue = SystemUtil.isWindows() ? "soffice.exe" : "libreoffice";
        return this.getBinPath("libreoffice", defValue);
    }

    private String getBinPath(String item, String defPath) {
        String path = defPath;
        String envPath = EnvUtil.getEnv((String)(item + ".bin"), (boolean)true);
        if (envPath != null && envPath.length() > 0) {
            path = envPath;
        }
        return path;
    }

    private void executeCommand(String cmd) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        if (SystemUtil.isWindows()) {
            args.add("cmd.exe");
            args.add("/c");
            args.add("\"" + cmd + "\"");
        } else {
            args.add("sh");
            args.add("-c");
            args.add(cmd);
        }
        this.executeCommand(args);
    }

    private void executeCommand(List<String> args) throws IOException {
        String cmdString = String.join((CharSequence)" ", args);
        LogUtil.log("Execute cmd: " + cmdString);
        Process process = Runtime.getRuntime().exec(args.toArray(new String[args.size()]));
        StreamReader streamGobbler = new StreamReader(process.getInputStream(), System.out::println);
        Executors.newSingleThreadExecutor().submit(streamGobbler);
        StreamReader streamGobblerErr = new StreamReader(process.getErrorStream(), System.err::println);
        Executors.newSingleThreadExecutor().submit(streamGobblerErr);
        int exitCode = 0;
        try {
            exitCode = process.waitFor();
            process.exitValue();
            if (exitCode != 0) {
                throw new RuntimeException(String.format("Exit code of cmd '%s' was %d", cmdString, exitCode));
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

