/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.gendoc.org;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.gendoc.DocUtil;
import net.edgemind.ibee.util.string.StringUtil;
import net.edgemind.ibee.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class OrgExtractorConfig {
    List<ItemConfig> itemConfigs = new ArrayList<ItemConfig>();

    public List<ItemConfig> getItemConfigs() {
        return this.itemConfigs;
    }

    public void setItemConfigs(List<ItemConfig> itemConfigs) {
        this.itemConfigs = itemConfigs;
    }

    public void fromXml(Element xml) throws IOException {
        for (Element elItem : XmlUtil.getChildrenByTagName((String)"item", (Element)xml)) {
            ItemConfig newConfig = new ItemConfig();
            this.itemConfigs.add(newConfig);
            newConfig.setMatch(DocUtil.getAttributeWithEnv(elItem, "match"));
            newConfig.setTitle(DocUtil.getAttributeWithEnv(elItem, "title"));
            newConfig.setRecursive(DocUtil.getAttributeWithEnv(elItem, "recursive", "false").equalsIgnoreCase("true"));
            newConfig.setId(DocUtil.getAttributeWithEnv(elItem, "id"));
            newConfig.setNamespace(DocUtil.getAttributeWithEnv(elItem, "namespace"));
            newConfig.addLevel(StringUtil.toInt((String)DocUtil.getAttributeWithEnv(elItem, "level"), null));
            String levels = DocUtil.getAttributeWithEnv(elItem, "levels");
            if (levels == null) continue;
            String[] stringArray = levels.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String level = stringArray[n2];
                newConfig.addLevel(StringUtil.toInt((String)level));
                ++n2;
            }
        }
    }

    public static class ItemConfig {
        public String match;
        public String title;
        public String id;
        private boolean recursive;
        private String namespace;
        public List<Integer> levels = new ArrayList<Integer>();

        public boolean isRecursive() {
            return this.recursive;
        }

        public void setRecursive(boolean recursive) {
            this.recursive = recursive;
        }

        public String getMatch() {
            return this.match;
        }

        public void setMatch(String match) {
            this.match = match;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String tocid) {
            this.id = tocid;
        }

        public List<Integer> getLevels() {
            return this.levels;
        }

        public void setLevels(List<Integer> levels) {
            this.levels = levels;
        }

        public void addLevel(Integer level) {
            if (level != null) {
                this.levels.add(level);
            }
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }
    }
}

