/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.gendoc.out.write;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.gendoc.DocUtil;
import net.edgemind.ibee.gendoc.common.Replication;
import net.edgemind.ibee.gendoc.common.ReplicationParser;
import net.edgemind.ibee.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class ItemWriterConfig {
    private ItemConfig itemConfig;
    private List<Replication> replications = new ArrayList<Replication>();
    private File outDir;
    private String format;
    private String file;

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public File getOutDir() {
        return this.outDir;
    }

    public void setOutDir(File outDir) {
        this.outDir = outDir;
    }

    public List<Replication> getReplications() {
        return this.replications;
    }

    public void setReplications(List<Replication> replications) {
        this.replications = replications;
    }

    public ItemConfig getItemConfigs() {
        return this.itemConfig;
    }

    public void setItemConfig(ItemConfig itemConfig) {
        this.itemConfig = itemConfig;
    }

    public void fromXml(Element xml) throws IOException {
        Element elOut;
        Element elItem;
        String outdir = DocUtil.getAttributeWithEnv(xml, "outdir");
        if (outdir != null) {
            this.setOutDir(new File(outdir));
        }
        if ((elItem = XmlUtil.getFirstChildByTagName((String)"item", (Element)xml)) != null) {
            ItemConfig newConfig = new ItemConfig();
            newConfig.setTitle(DocUtil.getAttributeWithEnv(elItem, "title"));
            newConfig.setId(DocUtil.getAttributeWithEnv(elItem, "id"));
            newConfig.setRecursive(DocUtil.getAttributeWithEnv(elItem, "recursive", "false").equalsIgnoreCase("true"));
            this.itemConfig = newConfig;
        }
        if ((elOut = XmlUtil.getFirstChildByTagName((String)"out", (Element)xml)) != null) {
            File file = new File(DocUtil.getAttributeWithEnv(elOut, "file"));
            this.setFile(file.getPath());
            if (this.outDir == null) {
                this.outDir = file.getParentFile();
            }
            this.setFormat(DocUtil.getAttributeWithEnv(elOut, "format"));
        }
        ReplicationParser replicationParser = new ReplicationParser();
        replicationParser.setWorkDir(this.outDir);
        this.replications = replicationParser.scanReplications(xml);
    }

    public static class ItemConfig {
        private String title;
        private String id;
        private boolean recursive = false;

        public boolean isRecursive() {
            return this.recursive;
        }

        public void setRecursive(boolean recursive) {
            this.recursive = recursive;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }
}

