/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.gendoc.pdf;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.gendoc.DocUtil;
import net.edgemind.ibee.util.string.StringUtil;
import net.edgemind.ibee.util.system.EnvUtil;
import net.edgemind.ibee.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class OrgToPdfGeneratorConfig {
    private File pdfOut;
    private File orgFile;
    private File initEl;
    private String title;
    private String version;
    private CreateOrg createOrg = null;

    public CreateOrg getCreateOrg() {
        return this.createOrg;
    }

    public void setCreateOrg(CreateOrg createOrg) {
        this.createOrg = createOrg;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public File getInitEl() {
        return this.initEl;
    }

    public void setInitEl(File initEl) {
        this.initEl = initEl;
    }

    public File getOrgFile() {
        return this.orgFile;
    }

    public void setOrgFile(File orgFile) {
        this.orgFile = orgFile;
    }

    public File getPdfOut() {
        return this.pdfOut;
    }

    public void setPdfOut(File pdfOut) {
        this.pdfOut = pdfOut;
    }

    public void fromXml(Element xml) throws IOException {
        String title = DocUtil.getAttributeWithEnv(xml, "title");
        this.setTitle(title);
        String version = DocUtil.getAttributeWithEnv(xml, "version");
        this.setVersion(version);
        String pdfOut = DocUtil.getAttributeWithEnv(xml, "pdfout");
        this.setPdfOut(new File(pdfOut));
        String orgfile = DocUtil.getAttributeWithEnv(xml, "orgfile");
        if (orgfile != null) {
            this.setOrgFile(new File(orgfile));
        }
        String initel = DocUtil.getAttributeWithEnv(xml, "initel");
        this.setInitEl(new File(initel));
        this.parseCreateOrgConfiguration(xml);
    }

    private void parseCreateOrgConfiguration(Element xml) {
        Element elCreateOrg = XmlUtil.getFirstChildByTagName((String)"create-org", (Element)xml);
        if (elCreateOrg != null) {
            Element imgFolders;
            Element elItems;
            CreateOrg createOrg = new CreateOrg();
            this.setCreateOrg(createOrg);
            Header header = this.parseHeader(elCreateOrg);
            if (header != null) {
                createOrg.setHeader(header);
            }
            if ((elItems = XmlUtil.getFirstChildByTagName((String)"items", (Element)elCreateOrg)) != null) {
                createOrg.setRecursive(DocUtil.getAttributeWithEnv(elItems, "recursive", "false").equalsIgnoreCase("true"));
                String levels = DocUtil.getAttributeWithEnv(elItems, "levels");
                if (levels != null) {
                    String[] stringArray = levels.split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String level = stringArray[n2];
                        createOrg.addLevel(StringUtil.toInt((String)level));
                        ++n2;
                    }
                }
                String namespace = DocUtil.getAttributeWithEnv(elItems, "namespace");
                createOrg.setNamespace(namespace);
            }
            if ((imgFolders = XmlUtil.getFirstChildByTagName((String)"img-folders", (Element)elCreateOrg)) != null) {
                for (Element elPath : XmlUtil.getChildrenByTagName((String)"dir", (Element)imgFolders)) {
                    String path = EnvUtil.replaceEnvVars((String)elPath.getTextContent());
                    createOrg.addImgDir(new File(path));
                }
            }
        }
    }

    private Header parseHeader(Element xml) {
        Header header = null;
        Element elHeader = XmlUtil.getFirstChildByTagName((String)"header", (Element)xml);
        if (elHeader != null) {
            header = new Header();
            header.setId(DocUtil.getAttributeWithEnv(elHeader, "id"));
            header.setRecursive(DocUtil.getAttributeWithEnv(elHeader, "recursive", "false").equalsIgnoreCase("true"));
        }
        return header;
    }

    public static class CreateOrg {
        private List<Integer> levels = new ArrayList<Integer>();
        private boolean recursive;
        private List<File> imgDirs = new ArrayList<File>();
        private String namespace;
        private Header header = null;

        public boolean isRecursive() {
            return this.recursive;
        }

        public void setRecursive(boolean recursive) {
            this.recursive = recursive;
        }

        public List<Integer> getLevels() {
            return this.levels;
        }

        public void setLevels(List<Integer> levels) {
            this.levels = levels;
        }

        public void addLevel(Integer level) {
            this.levels.add(level);
        }

        public void addImgDir(File dir) {
            this.imgDirs.add(dir);
        }

        public List<File> getImgDirs() {
            return this.imgDirs;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public Header getHeader() {
            return this.header;
        }

        public void setHeader(Header header) {
            this.header = header;
        }
    }

    public static class Header {
        private String id;
        private boolean recursive;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public boolean isRecursive() {
            return this.recursive;
        }

        public void setRecursive(boolean recursive) {
            this.recursive = recursive;
        }
    }
}

