/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.gendoc.toc;

import java.io.File;
import java.io.IOException;
import net.edgemind.ibee.gendoc.DocUtil;
import net.edgemind.ibee.gendoc.Item;
import net.edgemind.ibee.gendoc.ItemRepo;
import net.edgemind.ibee.gendoc.LogUtil;
import net.edgemind.ibee.gendoc.toc.TocGeneratorConfig;
import net.edgemind.ibee.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TocGenerator {
    private ItemRepo repo;
    private String htmlDir;

    public TocGenerator(ItemRepo repo) {
        this.repo = repo;
    }

    public void generate(TocGeneratorConfig genCfg) throws IOException {
        this.htmlDir = genCfg.getHtmlDir();
        Document doc = XmlUtil.createNewDocument();
        Element elToc = doc.createElement("toc");
        doc.appendChild(elToc);
        String anchor = genCfg.getAnchor();
        if (anchor != null && !anchor.isEmpty()) {
            elToc.setAttribute("link_to", anchor);
        }
        elToc.setAttribute("label", genCfg.getLabel());
        TocGeneratorConfig.AutoGeneration autoGen = genCfg.getAutoGeneration();
        if (autoGen != null) {
            TocGeneratorConfig.Topic topic = new TocGeneratorConfig.Topic();
            topic.setAutoGeneration(autoGen);
            this.createAutoTopics(topic);
            for (TocGeneratorConfig.Topic childTopic : topic.getChildTopics()) {
                this.generateTopic(childTopic, elToc);
            }
        }
        for (TocGeneratorConfig.Topic topic : genCfg.getTopics()) {
            this.createAutoTopics(topic);
        }
        for (TocGeneratorConfig.Topic topic : genCfg.getTopics()) {
            this.generateTopic(topic, elToc);
        }
        String tocFilePath = genCfg.getTocFile().getAbsolutePath();
        LogUtil.log(String.format("Write toc file %s", tocFilePath));
        XmlUtil.writeXmlFile((Document)doc, (String)tocFilePath);
    }

    private void createAutoTopics(TocGeneratorConfig.Topic topic) throws IOException {
        TocGeneratorConfig.AutoGeneration autoGen = topic.getAutoGeneration();
        if (autoGen != null) {
            for (Item item : this.repo.getItems()) {
                if (!this.checkNamespace(item, autoGen)) continue;
                this.createAutoTopicForItem(autoGen, item, topic);
            }
        }
        for (TocGeneratorConfig.Topic childTopic : topic.getChildTopics()) {
            this.createAutoTopics(childTopic);
        }
    }

    private void createAutoTopicForItem(TocGeneratorConfig.AutoGeneration autoGen, Item item, TocGeneratorConfig.Topic parentTopic) throws IOException {
        if (autoGen.getLevels().contains(item.getLevel())) {
            TocGeneratorConfig.Topic topic = new TocGeneratorConfig.Topic();
            topic.setLabel(this.getHtmlTitle(item));
            File htmlFile = this.getFile(item);
            topic.setHref(htmlFile.getPath());
            parentTopic.addChildTopic(topic);
            parentTopic = topic;
        }
        for (Item childItem : item.getChilds()) {
            this.createAutoTopicForItem(autoGen, childItem, parentTopic);
        }
    }

    private boolean checkNamespace(Item item, TocGeneratorConfig.AutoGeneration autoGen) {
        String requiredNs = autoGen.getNamespace();
        return DocUtil.checkNamespace(item, requiredNs);
    }

    private File getFile(Item item) {
        String id = item.getQid();
        id = DocUtil.normalizeId(id);
        String href = id + ".html";
        return new File(href);
    }

    private void generateTopic(TocGeneratorConfig.Topic topic, Element elParent) throws IOException {
        Element elTopic = elParent.getOwnerDocument().createElement("topic");
        elParent.appendChild(elTopic);
        XmlUtil.setAttribute((Element)elTopic, (String)"label", (String)topic.getLabel(), (boolean)false);
        String href = topic.getHref();
        if (href != null && href.length() > 0) {
            Object htmlHref = topic.getHref();
            if (this.htmlDir != null && this.htmlDir.length() > 0) {
                htmlHref = this.htmlDir + "/" + (String)htmlHref;
            }
            XmlUtil.setAttribute((Element)elTopic, (String)"href", (String)htmlHref, (boolean)false);
        }
        for (TocGeneratorConfig.Topic childTopic : topic.getChildTopics()) {
            this.generateTopic(childTopic, elTopic);
        }
    }

    private String getHtmlTitle(Item item) {
        String title = item.getTitle();
        title = title.replaceAll("\\*", "");
        title = title.replaceAll("\"", "");
        title = title.replaceAll("=", "");
        return title;
    }
}

