/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.gendoc.toc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.gendoc.DocUtil;
import net.edgemind.ibee.util.string.StringUtil;
import net.edgemind.ibee.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class TocGeneratorConfig {
    private List<Topic> topics = new ArrayList<Topic>();
    private File tocFile;
    private String anchor;
    private String label;
    private AutoGeneration autoGeneration;
    String htmlDir;

    public String getHtmlDir() {
        return this.htmlDir;
    }

    public void setHtmlDir(String htmlDir) {
        this.htmlDir = htmlDir;
    }

    public AutoGeneration getAutoGeneration() {
        return this.autoGeneration;
    }

    public void setAutoGeneration(AutoGeneration autoGeneration) {
        this.autoGeneration = autoGeneration;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public List<Topic> getTopics() {
        return this.topics;
    }

    public void setTopics(List<Topic> topics) {
        this.topics = topics;
    }

    public File getTocFile() {
        return this.tocFile;
    }

    public void setTocFile(File tocFile) {
        this.tocFile = tocFile;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public void setAnchor(String anchor) {
        this.anchor = anchor;
    }

    public void fromXml(Element xml) throws IOException {
        String tocFile = DocUtil.getAttributeWithEnv(xml, "tocfile");
        this.setTocFile(new File(tocFile));
        this.setLabel(DocUtil.getAttributeWithEnv(xml, "label"));
        this.setAnchor(DocUtil.getAttributeWithEnv(xml, "anchor"));
        String htmlDir = DocUtil.getAttributeWithEnv(xml, "htmldir");
        this.setHtmlDir(htmlDir);
        for (Element elTopic : XmlUtil.getChildrenByTagName((String)"topic", (Element)xml)) {
            Topic topic = new Topic();
            this.topics.add(topic);
            topic.setLabel(DocUtil.getAttributeWithEnv(elTopic, "label"));
            topic.setHref(DocUtil.getAttributeWithEnv(elTopic, "href"));
            this.parseChildTopics(topic, elTopic);
            this.parseAutoGeneration(elTopic, topic);
        }
        this.parseAutoGeneration(xml, null);
    }

    private void parseAutoGeneration(Element xml, Topic topic) {
        Element elAuto = XmlUtil.getFirstChildByTagName((String)"auto", (Element)xml);
        if (elAuto != null) {
            AutoGeneration autoGeneration = new AutoGeneration();
            if (topic != null) {
                topic.setAutoGeneration(autoGeneration);
            } else {
                this.setAutoGeneration(autoGeneration);
            }
            String levels = DocUtil.getAttributeWithEnv(elAuto, "levels");
            if (levels != null) {
                String[] stringArray = levels.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String level = stringArray[n2];
                    autoGeneration.addLevel(StringUtil.toInt((String)level.trim()));
                    ++n2;
                }
            }
            autoGeneration.setNamespace(DocUtil.getAttributeWithEnv(elAuto, "namespace"));
        }
    }

    private void parseChildTopics(Topic topic, Element elTopic) {
        for (Element elChildTopic : XmlUtil.getChildrenByTagName((String)"topic", (Element)elTopic)) {
            Topic childTopic = new Topic();
            topic.addChildTopic(childTopic);
            childTopic.setLabel(DocUtil.getAttributeWithEnv(elChildTopic, "label"));
            childTopic.setHref(DocUtil.getAttributeWithEnv(elChildTopic, "href"));
            this.parseChildTopics(childTopic, elChildTopic);
            this.parseAutoGeneration(elChildTopic, childTopic);
        }
    }

    public static class AutoGeneration {
        List<Integer> levels = new ArrayList<Integer>();
        private String namespace;

        public List<Integer> getLevels() {
            return this.levels;
        }

        public void setLevels(List<Integer> levels) {
            this.levels = levels;
        }

        public void addLevel(Integer level) {
            this.levels.add(level);
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }
    }

    public static class Topic {
        private String label;
        private String href;
        private List<Topic> childTopics = new ArrayList<Topic>();
        private AutoGeneration autoGeneration;

        public AutoGeneration getAutoGeneration() {
            return this.autoGeneration;
        }

        public void setAutoGeneration(AutoGeneration autoGeneration) {
            this.autoGeneration = autoGeneration;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getHref() {
            return this.href;
        }

        public void setHref(String href) {
            this.href = href;
        }

        public List<Topic> getChildTopics() {
            return this.childTopics;
        }

        public void setChildTopics(List<Topic> childTopics) {
            this.childTopics = childTopics;
        }

        public void addChildTopic(Topic topic) {
            this.childTopics.add(topic);
        }
    }
}

