/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.gendoc.wikimedia;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public class WikiToEmConverter {
    private URI baseUri;

    public void setBaseUri(URI baseUri) {
        this.baseUri = baseUri;
    }

    public String convert(String in) {
        in = in.replaceAll("&", "&amp;");
        in = this.escapeNonInlineTagsAngleBracket(in);
        in = this.processSections(in);
        in = this.processStyles(in);
        in = this.processInternalLinks(in);
        in = this.processExternalLinks(in);
        in = this.parseTables(in);
        in = this.processLists(in);
        in = in.replaceAll("<br/?>[ \t]*\n", "%/:");
        in = in.replaceAll("\n[ \t]*<br/?>", "%/:");
        in = in.replaceAll("\n", "%/%");
        in = in.replaceAll("<br>", "%/:");
        in = in.replaceAll("<br/>", "%/:");
        in = this.wrapRootTextAndInlineElementsInParagraphs(in);
        in = this.removeNewlineMarkers(in);
        in = in.replaceAll("%/:", "<br/>");
        in = in.replaceAll("\n", "");
        return in;
    }

    /*
     * Unable to fully structure code
     */
    private String processLists(String wikiText) {
        htmlText = new StringBuilder();
        lines = wikiText.split("\\r?\\n");
        listStack = new Stack<String>();
        var8_5 = lines;
        var7_6 = lines.length;
        var6_7 = 0;
        while (var6_7 < var7_6) {
            block4: {
                block3: {
                    line = var8_5[var6_7];
                    unorderedMatcher = Pattern.compile("^(\\*+)(.*)").matcher(line);
                    orderedMatcher = Pattern.compile("^(#+)(.*)").matcher(line);
                    if (!unorderedMatcher.find()) break block3;
                    level = unorderedMatcher.group(1).length();
                    content = unorderedMatcher.group(2).trim();
                    this.processList(htmlText, listStack, "ul", level, content);
                    break block4;
                }
                if (!orderedMatcher.find()) ** GOTO lbl24
                level = orderedMatcher.group(1).length();
                content = orderedMatcher.group(2).trim();
                this.processList(htmlText, listStack, "ol", level, content);
                break block4;
lbl-1000:
                // 1 sources

                {
                    htmlText.append("</").append((String)listStack.pop()).append(">");
lbl24:
                    // 2 sources

                    ** while (!listStack.isEmpty())
                }
lbl25:
                // 1 sources

                htmlText.append(line).append("\n");
            }
            ++var6_7;
        }
        while (!listStack.isEmpty()) {
            htmlText.append("</").append((String)listStack.pop()).append(">");
        }
        return htmlText.toString();
    }

    private void processList(StringBuilder htmlText, Stack<String> listStack, String listType, int level, String content) {
        while (!(listStack.isEmpty() || listStack.size() <= level && listStack.peek().equals(listType))) {
            htmlText.append("</").append(listStack.pop()).append(">");
        }
        while (listStack.size() < level) {
            listStack.push(listType);
            htmlText.append("<").append(listType).append(">");
        }
        htmlText.append("<li>").append(content).append("</li>");
    }

    private String processSections(String wikiText) {
        wikiText = this.replaceAll(wikiText, "(?m)^\\s*======\\s*(.*?)\\s*======", s -> "<h6 id=\"" + this.toId((String)s) + "\">" + s + "</h6>");
        wikiText = this.replaceAll(wikiText, "(?m)^\\s*=====\\s*(.*?)\\s*=====", s -> "<h5 id=\"" + this.toId((String)s) + "\">" + s + "</h5>");
        wikiText = this.replaceAll(wikiText, "(?m)^\\s*====\\s*(.*?)\\s*====", s -> "<h4 id=\"" + this.toId((String)s) + "\">" + s + "</h4>");
        wikiText = this.replaceAll(wikiText, "(?m)^\\s*===\\s*(.*?)\\s*===", s -> "<h3 id=\"" + this.toId((String)s) + "\">" + s + "</h3>");
        wikiText = this.replaceAll(wikiText, "(?m)^\\s*==\\s*(.*?)\\s*==", s -> "<h2 id=\"" + this.toId((String)s) + "\">" + s + "</h2>");
        wikiText = this.replaceAll(wikiText, "(?m)^\\s*=\\s*(.*?)\\s*=", s -> "<h1 id=\"" + this.toId((String)s) + "\">" + s + "</h1>");
        return wikiText;
    }

    public String wrapRootTextAndInlineElementsInParagraphs(String html) {
        Element body = new Element("body");
        body.html(html);
        ArrayList<Node> nodesToWrap = new ArrayList<Node>();
        for (Node node : body.childNodes()) {
            if (node instanceof TextNode) {
                String text = ((TextNode)node).text().trim();
                if (text.isEmpty()) continue;
                nodesToWrap.add(node);
                continue;
            }
            if (this.isInlineElement(node)) {
                nodesToWrap.add(node);
                continue;
            }
            if (nodesToWrap.isEmpty()) continue;
            this.wrapNodesInParagraph(nodesToWrap, body);
        }
        if (!nodesToWrap.isEmpty()) {
            this.wrapNodesInParagraph(nodesToWrap, body);
        }
        this.convertNewlinesInTextNodesToHtmlBreaks(body);
        return this.getHtml(body);
    }

    public String escapeNonInlineTagsAngleBracket(String html) {
        if (html == null || html.isEmpty()) {
            return html;
        }
        StringBuilder out = new StringBuilder((int)((double)html.length() * 1.1));
        int i = 0;
        int n = html.length();
        while (i < n) {
            if (i + 3 <= n && html.startsWith("<u>", i)) {
                out.append("<u>");
                i += 3;
                continue;
            }
            if (i + 4 <= n && html.startsWith("</u>", i)) {
                out.append("</u>");
                i += 4;
                continue;
            }
            if (i + 4 <= n && html.startsWith("<br>", i)) {
                out.append("<br>");
                i += 4;
                continue;
            }
            if (i + 5 <= n && html.startsWith("<br/>", i)) {
                out.append("<br/>");
                i += 5;
                continue;
            }
            char c = html.charAt(i);
            if (c == '<') {
                out.append("&lt;");
            } else if (c == '>') {
                out.append("&gt;");
            } else {
                out.append(c);
            }
            ++i;
        }
        return out.toString();
    }

    private void wrapNodesInParagraph(List<Node> nodes, Element parent) {
        if (nodes.isEmpty()) {
            return;
        }
        int index = nodes.get(0).siblingIndex();
        Element p = new Element("p");
        for (Node node : nodes) {
            p.appendChild(node);
        }
        parent.insertChildren(index, new Node[]{p});
        nodes.clear();
    }

    private String convertNewlinesInTextNodesToHtmlBreaks(Element body) {
        for (Element p : body.getElementsByTag("p")) {
            int index = p.siblingIndex();
            String html = this.getHtml(p);
            html = html.trim();
            String sep = "(\\s*%/%)";
            String[] paragraphs = html.split(sep + sep + "+");
            p.remove();
            String[] stringArray = paragraphs;
            int n = paragraphs.length;
            int n2 = 0;
            while (n2 < n) {
                String paragraph = stringArray[n2];
                paragraph = paragraph.replaceAll("^" + sep + "*", "");
                paragraph = paragraph.replaceAll(sep + "*$", "");
                if (!(paragraph = paragraph.replaceAll("%/%", "%/:")).isEmpty()) {
                    Element newP = new Element("p");
                    newP.html(paragraph);
                    body.insertChildren(index++, new Node[]{newP});
                }
                ++n2;
            }
        }
        return body.toString();
    }

    String getHtml(Element e) {
        return e.html();
    }

    private boolean isInlineElement(Node node) {
        if (!(node instanceof Element)) {
            return false;
        }
        String tag = ((Element)node).tagName();
        return tag.matches("img|br|a|b|i|strong|em|u|del|mark|span|small|sub|sup|code|kbd|samp|var|abbr|cite|dfn|q|bdo|bdi");
    }

    private String processStyles(String wikiText) {
        wikiText = wikiText.replaceAll("--(.*?)--", "<del>$1</del>");
        wikiText = wikiText.replaceAll("'''''(.*?)'''''", "<i><b>$1</b></i>");
        wikiText = wikiText.replaceAll("'''(.*?)'''", "<b>$1</b>");
        wikiText = wikiText.replaceAll("''(.*?)''", "<i>$1</i>");
        return wikiText;
    }

    private String processInternalLinks(String wikiText) {
        wikiText = this.processInternalImageLinks(wikiText);
        wikiText = this.processInternalPageLinks(wikiText);
        return wikiText;
    }

    private String processInternalImageLinks(String wikiText) {
        wikiText = wikiText.replaceAll("\\[\\[\\s*Image:([^|\\]]+?)\\s*\\|\\s*([^\\]]+?)(px|cm)?\\s*\\]\\s*\\]", "<img width=\"$2\" border=\"0\" src=\"$1\"/>");
        wikiText = wikiText.replaceAll("\\[\\[\\s*Image:([^\\]]+?)\\s*\\]\\s*\\]", "<img border=\"0\" src=\"$1\" />");
        return wikiText;
    }

    private String processInternalPageLinks(String wikiText) {
        wikiText = wikiText.replaceAll("\\[\\[([^|\\]]+)\\|([^\\]]+)\\]\\]", "<a href=\"L%%%$1%%%R\">$2</a>");
        wikiText = wikiText.replaceAll("\\[\\[([^\\]]+)\\]\\]", "<a href=\"L%%%$1%%%R\">$1</a>");
        wikiText = this.replaceAll(wikiText, "L%%%(.*?)%%%R", s -> this.toId((String)s));
        return wikiText;
    }

    private String toId(String s) {
        return s.replaceAll("\\s+", "_");
    }

    private String processExternalLinks(String wikiText) {
        wikiText = wikiText.replaceAll("\\[\\s*([^| \\]]+?)(\\s*\\|| |\\t\\s*)([^\\]]+)\\s*\\]", "<a href=\"L%%%$1%%%R\">L\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd$3\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdR</a>");
        wikiText = wikiText.replaceAll("\\[\\s*([^\\]]+)\\s*\\]", "<a href=\"L%%%$1%%%R\">L\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd$1\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdR</a>");
        wikiText = this.replaceAll(wikiText, "L%%%(.*?)%%%R", s -> this.convertToExternalUrl((String)s));
        wikiText = this.replaceAll(wikiText, "L\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd(.*?)\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdR", s -> this.convertToExternalDisplayName((String)s));
        return wikiText;
    }

    private String convertToExternalUrl(String s) {
        if (this.baseUri != null && this.isFileUrl(s)) {
            try {
                URL url = new URL(s);
                s = url.toString();
                File f = new File(url.getFile());
                if (!f.isAbsolute()) {
                    String filePath = url.getFile();
                    s = Paths.get(this.baseUri.toString(), filePath).toString();
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return s;
    }

    private boolean isFileUrl(String url) {
        return url.toLowerCase().startsWith("file");
    }

    private String convertToExternalDisplayName(String s) {
        s = s.trim();
        try {
            s = URLDecoder.decode(s, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        if (s.toLowerCase().startsWith("file:")) {
            s = s.substring("file:".length());
        }
        return s;
    }

    private String replaceAll(String text, String patternS, Function<String, String> converter) {
        Pattern pattern = Pattern.compile(patternS);
        Matcher matcher = pattern.matcher(text);
        StringBuffer buf = new StringBuffer();
        int last = 0;
        while (matcher.find()) {
            buf.append(text.subSequence(last, matcher.start()));
            String s = converter.apply(matcher.group(1));
            buf.append(s);
            last = matcher.end();
        }
        buf.append(text.subSequence(last, text.length()));
        return buf.toString();
    }

    private String parseTables(String wikiText) {
        String tableStartPattern = "\\{\\|";
        String tableEndPattern = "\\|\\}";
        String rowPattern = "\\n\\s*\\|-\\s*\\n";
        String cellSep = "((^|\\n)\\s*(\\||!)|!!|\\|\\|)";
        String cellPattern = cellSep + "(.+?)(" + cellSep + "|$)";
        Pattern tablePattern = Pattern.compile(tableStartPattern + "(.*?)" + tableEndPattern, 32);
        Matcher tableMatcher = tablePattern.matcher(wikiText);
        StringBuffer htmlText = new StringBuffer();
        while (tableMatcher.find()) {
            String[] rows;
            String tableContent = tableMatcher.group(1).trim();
            tableContent = this.removeNewlineMarkers(tableContent);
            StringBuilder tableHtml = new StringBuilder("<table>");
            String[] stringArray = rows = tableContent.split(rowPattern);
            int n = rows.length;
            int n2 = 0;
            while (n2 < n) {
                String row = stringArray[n2];
                tableHtml.append("<tr>");
                Pattern cellPatternCompiled = Pattern.compile(cellPattern, 32);
                Matcher cellMatcher = cellPatternCompiled.matcher(row);
                int colIndex = 0;
                while (cellMatcher.find(colIndex)) {
                    String cell = cellMatcher.group(4).trim();
                    if (cell.contains("|")) {
                        int index = cell.lastIndexOf("|");
                        cell = cell.substring(index + 1).trim();
                    }
                    String separator = cellMatcher.group(1).trim();
                    colIndex = cellMatcher.end(4);
                    if (separator.equals("|") || separator.equals("||")) {
                        tableHtml.append("<td>").append(cell.trim()).append("</td>");
                        continue;
                    }
                    if (!separator.equals("!") && !separator.equals("!!")) continue;
                    tableHtml.append("<th>").append(cell.trim()).append("</th>");
                }
                tableHtml.append("</tr>");
                ++n2;
            }
            tableHtml.append("</table>");
            tableMatcher.appendReplacement(htmlText, tableHtml.toString());
        }
        tableMatcher.appendTail(htmlText);
        return htmlText.toString();
    }

    private String removeNewlineMarkers(String in) {
        in = in.replaceAll("%/%", "");
        return in;
    }
}

