/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.licensing.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.edgemind.ibee.licensing.core.CipherType;
import net.edgemind.ibee.licensing.core.Converter;
import net.edgemind.ibee.licensing.core.Token;
import net.edgemind.ibee.licensing.core.annotation.TokenEntity;
import net.edgemind.ibee.licensing.core.annotation.TokenPart;
import net.edgemind.ibee.licensing.core.impl.CipherEngine;
import net.edgemind.ibee.licensing.core.impl.Converters;
import net.edgemind.ibee.licensing.core.impl.GZIP;
import net.edgemind.ibee.licensing.core.impl.Reflector;
import org.apache.commons.lang3.ArrayUtils;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Base64;

public class Tokenizer {
    private static final Map<Class<?>, Field[]> MAPPING = new HashMap();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final byte[] CMP_MARKER = new byte[]{99, 109, 112};
    private static final byte[] DCP_MARKER = new byte[]{100, 99, 112};
    private static final CipherType DEFAULT_CIPHER = CipherType.AES;

    private static Field[] getParts(Class<?> clazz) {
        Field[] parts = MAPPING.get(clazz);
        if (parts != null) {
            return parts;
        }
        HashMap<String, Field> convertable = new HashMap<String, Field>();
        Class<?> c = clazz;
        do {
            Field[] fields;
            Field[] fieldArray = fields = c.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                Class<?> type = field.getType();
                if (!Converters.canConvert(type)) {
                    throw new IllegalArgumentException(String.format("Only basic type can be a token part, %s detected", type));
                }
                TokenPart tp = field.getAnnotation(TokenPart.class);
                if (tp != null) {
                    String name = tp.value();
                    if (convertable.get(name) != null) {
                        throw new RuntimeException("Two or more fields cannot be annotated with the same token part name");
                    }
                    field.setAccessible(true);
                    convertable.put(name, field);
                }
                ++n2;
            }
        } while ((c = c.getSuperclass()) != null);
        parts = convertable.values().toArray(new Field[convertable.size()]);
        MAPPING.put(clazz, parts);
        return parts;
    }

    private static boolean startsWith(byte[] source, byte[] match) {
        if (match.length > source.length) {
            return false;
        }
        int i = 0;
        while (i < match.length) {
            if (source[i] != match[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String tokenize(Token tokenizable, String password) {
        return Tokenizer.tokenize(tokenizable, DEFAULT_CIPHER, password);
    }

    public static String tokenize(Token tokenizable, CipherType type, String password) {
        if (type == CipherType.NOOP) {
            return Tokenizer.tokenize0(tokenizable);
        }
        byte[] decrypted = Strings.toUTF8ByteArray((String)Tokenizer.tokenize0(tokenizable));
        byte[] compressed = GZIP.compress(decrypted);
        byte[] mark = DCP_MARKER;
        if (compressed.length < decrypted.length) {
            mark = CMP_MARKER;
            decrypted = compressed;
        }
        byte[] input = new byte[decrypted.length + mark.length];
        System.arraycopy(mark, 0, input, 0, mark.length);
        System.arraycopy(decrypted, 0, input, mark.length, decrypted.length);
        byte[] encrypted = CipherEngine.encrypt(type, password, input);
        return Strings.fromUTF8ByteArray((byte[])Base64.encode((byte[])encrypted));
    }

    private static TokenEntity getTokenEntity(Class<? extends Token> clazz) {
        Class<? extends Token> c = clazz;
        TokenEntity tf = null;
        do {
            if ((tf = c.getAnnotation(TokenEntity.class)) == null) {
                Class<?>[] classArray = c.getInterfaces();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> i = classArray[n2];
                    tf = i.getAnnotation(TokenEntity.class);
                    if (tf != null) {
                        return tf;
                    }
                    ++n2;
                }
            } else {
                return tf;
            }
        } while ((c = clazz.getSuperclass()) != null);
        return null;
    }

    private static final String tokenize0(Token tokenizable) {
        Field[] parts;
        Class<?> clazz = tokenizable.getClass();
        Constructor<?> ctor = Reflector.getConstructor(clazz, new Class[0]);
        if (ctor == null) {
            throw new IllegalArgumentException(String.format("Default constructor missing in %s", clazz));
        }
        StringBuilder sb = new StringBuilder();
        String delimiter = null;
        String d = "";
        TokenEntity tf = Tokenizer.getTokenEntity(clazz);
        delimiter = tf.delimiter();
        if (delimiter.length() == 0) {
            throw new IllegalArgumentException("Token delimiter cannot be empty");
        }
        Field[] fieldArray = parts = Tokenizer.getParts(tokenizable.getClass());
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            Field part = fieldArray[n2];
            Object value = Reflector.getValue(part, tokenizable);
            TokenPart tp = part.getAnnotation(TokenPart.class);
            String string = Converters.toString(value);
            if (string.indexOf(delimiter) != -1) {
                throw new IllegalArgumentException(String.format("Cannot build token because part '%s' contains delimiter string '%s'", string, delimiter));
            }
            sb.append(d);
            sb.append(tp.value());
            sb.append('=');
            sb.append(string);
            d = delimiter;
            ++n2;
        }
        return sb.toString();
    }

    public static <T extends Token> T objectify(Class<T> clazz, String token, String password) {
        return Tokenizer.objectify(clazz, token, DEFAULT_CIPHER, password);
    }

    public static <T extends Token> T objectify(Class<T> clazz, String token, CipherType type, String password) {
        if (type == CipherType.NOOP) {
            return Tokenizer.objectify0(clazz, token);
        }
        byte[] encrypted = Base64.decode((byte[])Strings.toUTF8ByteArray((String)token));
        byte[] decrypted = CipherEngine.decrypt(type, password, encrypted);
        byte[] output = null;
        if (Tokenizer.startsWith(decrypted, CMP_MARKER)) {
            output = ArrayUtils.subarray((byte[])decrypted, (int)CMP_MARKER.length, (int)decrypted.length);
            output = GZIP.uncompress(output);
        } else {
            output = ArrayUtils.subarray((byte[])decrypted, (int)DCP_MARKER.length, (int)decrypted.length);
        }
        return Tokenizer.objectify0(clazz, Strings.fromUTF8ByteArray((byte[])output));
    }

    private static final <T extends Token> T objectify0(Class<T> clazz, String token) {
        Field[] parts;
        Token object = (Token)Reflector.newInstance(clazz, new Object[0]);
        String delimiter = null;
        TokenEntity tf = Tokenizer.getTokenEntity(clazz);
        delimiter = tf.delimiter();
        if (delimiter.length() == 0) {
            throw new IllegalArgumentException("Token delimiter cannot be empty");
        }
        int i = 0;
        HashMap<String, String> elements = new HashMap<String, String>();
        String[] stringArray = Tokenizer.split(token, delimiter);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            i = string.indexOf(61);
            elements.put(string.substring(0, i), string.substring(i + 1));
            ++n2;
        }
        Field[] fieldArray = parts = Tokenizer.getParts(clazz);
        int n3 = parts.length;
        n = 0;
        while (n < n3) {
            Field part = fieldArray[n];
            TokenPart tp = part.getAnnotation(TokenPart.class);
            String key = tp.value();
            String string = (String)elements.get(key);
            Object value = Converters.toObject(part.getType(), string);
            Reflector.setValue(part, object, value);
            ++n;
        }
        return (T)object;
    }

    /*
     * Unable to fully structure code
     */
    private static String[] split(String string, String separator) {
        block10: {
            block9: {
                if (string == null) {
                    return null;
                }
                len = string.length();
                if (len == 0) {
                    return Tokenizer.EMPTY_STRING_ARRAY;
                }
                list = new ArrayList<String>();
                i = 0;
                start = 0;
                match = false;
                last = false;
                if (separator != null) break block9;
                while (i < len) {
                    if (Character.isWhitespace(string.charAt(i))) {
                        last = true;
                        list.add(string.substring(start, i));
                        match = false;
                        start = ++i;
                        continue;
                    }
                    last = false;
                    match = true;
                    ++i;
                }
                break block10;
            }
            if (separator.length() != 1) ** GOTO lbl51
            sep = separator.charAt(0);
            while (i < len) {
                if (string.charAt(i) == sep) {
                    last = true;
                    list.add(string.substring(start, i));
                    match = false;
                    start = ++i;
                    continue;
                }
                last = false;
                match = true;
                ++i;
            }
            break block10;
lbl-1000:
            // 1 sources

            {
                if (separator.indexOf(string.charAt(i)) >= 0) {
                    last = true;
                    list.add(string.substring(start, i));
                    match = false;
                    start = ++i;
                    continue;
                }
                last = false;
                match = true;
                ++i;
lbl51:
                // 3 sources

                ** while (i < len)
            }
        }
        if (match || last) {
            list.add(string.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static <C> void register(Class<C> clazz, Converter<C> converter) {
        Converters.register(clazz, converter);
    }

    public static <C> void unregister(Class<C> clazz) {
        Converters.unregister(clazz);
    }
}

