/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.licensing.core.impl;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.edgemind.ibee.licensing.core.CipherType;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Strings;

public class CipherEngine {
    private static final Map<String, Cipher> CIPHERS;
    private static final Map<String, Key> KEYS;
    private static final Map<String, IvParameterSpec> IVS;

    static {
        CipherEngine.setup();
        CIPHERS = new HashMap<String, Cipher>();
        KEYS = new HashMap<String, Key>();
        IVS = new HashMap<String, IvParameterSpec>();
    }

    private static final void setup() {
        if (Security.getProvider("BC") == null) {
            try {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static final Cipher getCipher(CipherType type, String password) {
        String key = type.getAlgorithm() + ":" + password;
        Cipher cipher = CIPHERS.get(key);
        if (cipher != null) {
            return cipher;
        }
        String algorithm = type.getAlgorithm();
        try {
            cipher = Cipher.getInstance(algorithm, "BC");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
        CIPHERS.put(key, cipher);
        return cipher;
    }

    private static final Key getKey(CipherType type, String password) {
        String kkey = type.getAlgorithm() + ":" + password;
        Key key = KEYS.get(kkey);
        if (key != null) {
            return key;
        }
        key = new SecretKeySpec(CipherEngine.hmac(type, password), type.getAlgorithm());
        KEYS.put(kkey, key);
        return key;
    }

    private static final IvParameterSpec getIV(CipherType type, String password) {
        String key = type.getAlgorithm() + ":" + password;
        IvParameterSpec ivspec = IVS.get(key);
        if (ivspec != null) {
            return ivspec;
        }
        ivspec = new IvParameterSpec(CipherEngine.hmac(type, password));
        IVS.put(key, ivspec);
        return ivspec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] hmac(CipherType type, String string) {
        Digest digest = type.getDigest();
        byte[] hmac = new byte[digest.getDigestSize()];
        byte[] data = Strings.toUTF8ByteArray((String)string);
        Digest digest2 = digest;
        synchronized (digest2) {
            HMac h = new HMac(digest);
            h.update(data, 0, data.length);
            h.doFinal(hmac, 0);
            digest.reset();
        }
        return hmac;
    }

    private static final void init(Cipher cipher, int mode, Key key, AlgorithmParameterSpec param) {
        try {
            cipher.init(mode, key, param);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(String.format("Invalid key in %s", cipher.getAlgorithm()), e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e);
        }
    }

    private static final byte[] process(Cipher cipher, byte[] data) {
        try {
            return cipher.doFinal(data);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] encrypt(CipherType type, String password, byte[] decrypted) {
        Cipher cipher = CipherEngine.getCipher(type, password);
        Key key = CipherEngine.getKey(type, password);
        IvParameterSpec iv = CipherEngine.getIV(type, password);
        Cipher cipher2 = cipher;
        synchronized (cipher2) {
            CipherEngine.init(cipher, 1, key, iv);
            return CipherEngine.process(cipher, decrypted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] decrypt(CipherType type, String password, byte[] encrypted) {
        Cipher cipher = CipherEngine.getCipher(type, password);
        Key key = CipherEngine.getKey(type, password);
        IvParameterSpec iv = CipherEngine.getIV(type, password);
        Cipher cipher2 = cipher;
        synchronized (cipher2) {
            CipherEngine.init(cipher, 2, key, iv);
            return CipherEngine.process(cipher, encrypted);
        }
    }

    public static void main(String[] args) {
        byte[] encoded;
        CipherEngine.setup();
        byte[] bytes = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] byArray = encoded = CipherEngine.encrypt(CipherType.BLOWFISH, "test1234", bytes);
        int n = encoded.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            System.out.print(b + " ");
            ++n2;
        }
    }
}

