/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.licensing.core.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import net.edgemind.ibee.licensing.core.Converter;

public class Converters {
    private static final Map<Class<?>, Class<?>> PRIMITIVES_MAPPING = new HashMap();
    private static final Map<Class<?>, Converter<?>> CONVERTERS = new HashMap();
    private static boolean initialized = false;

    private static void init() {
        if (initialized) {
            return;
        }
        PRIMITIVES_MAPPING.put(Boolean.TYPE, Boolean.class);
        PRIMITIVES_MAPPING.put(Character.TYPE, Character.class);
        PRIMITIVES_MAPPING.put(Byte.TYPE, Byte.class);
        PRIMITIVES_MAPPING.put(Short.TYPE, Short.class);
        PRIMITIVES_MAPPING.put(Integer.TYPE, Integer.class);
        PRIMITIVES_MAPPING.put(Long.TYPE, Long.class);
        PRIMITIVES_MAPPING.put(Float.TYPE, Float.class);
        PRIMITIVES_MAPPING.put(Double.TYPE, Double.class);
        Converters.register(String.class, new StringConverter());
        Converters.register(Boolean.TYPE, new BooleanConverter());
        Converters.register(Character.TYPE, new CharacterConverter());
        Converters.register(Byte.TYPE, new ByteConverter());
        Converters.register(Short.TYPE, new ShortConverter());
        Converters.register(Integer.TYPE, new IntegerConverter());
        Converters.register(Long.TYPE, new LongConverter());
        Converters.register(Float.TYPE, new FloatConverter());
        Converters.register(Double.TYPE, new DoubleConverter());
        Converters.register(Void.class, new VoidConverter());
        Converters.register(BigDecimal.class, new BigDecimalConverter());
        Converters.register(BigInteger.class, new BigIntegerConverter());
        initialized = true;
    }

    public static <C> void register(Class<C> clazz, Converter<C> converter) {
        CONVERTERS.put(clazz, converter);
        if (clazz.isPrimitive()) {
            CONVERTERS.put(PRIMITIVES_MAPPING.get(clazz), converter);
        }
    }

    public static <C> void unregister(Class<C> clazz) {
        CONVERTERS.remove(clazz);
        if (clazz.isPrimitive()) {
            CONVERTERS.remove(PRIMITIVES_MAPPING.get(clazz));
        }
    }

    public static boolean canConvert(Class<?> type) {
        Converters.init();
        return CONVERTERS.get(type) != null;
    }

    public static final String toString(Object object) {
        Converters.init();
        Class<?> clazz = object.getClass();
        Converter<?> cnv = CONVERTERS.get(clazz);
        if (cnv == null) {
            throw new IllegalArgumentException(String.format("Translator for %s not found", clazz));
        }
        return cnv.toString(object);
    }

    public static final Object toObject(Class<?> clazz, String string) {
        Converters.init();
        Converter<?> cnv = CONVERTERS.get(clazz);
        if (cnv == null) {
            throw new IllegalArgumentException(String.format("Translator for %s not found", clazz));
        }
        return cnv.toObject(string);
    }

    private static final class BigDecimalConverter
    implements Converter<BigDecimal> {
        private BigDecimalConverter() {
        }

        @Override
        public BigDecimal toObject(String string) {
            return new BigDecimal(string);
        }

        @Override
        public String toString(BigDecimal object) {
            return object.toEngineeringString();
        }
    }

    private static final class BigIntegerConverter
    implements Converter<BigInteger> {
        private BigIntegerConverter() {
        }

        @Override
        public BigInteger toObject(String string) {
            return new BigInteger(string);
        }

        @Override
        public String toString(BigInteger object) {
            return object.toString();
        }
    }

    private static final class BooleanConverter
    implements Converter<Boolean> {
        private BooleanConverter() {
        }

        @Override
        public Boolean toObject(String string) {
            return Boolean.parseBoolean(string);
        }

        @Override
        public String toString(Boolean object) {
            return Boolean.toString(object);
        }
    }

    private static final class ByteConverter
    implements Converter<Byte> {
        private ByteConverter() {
        }

        @Override
        public Byte toObject(String string) {
            return Byte.parseByte(string);
        }

        @Override
        public String toString(Byte object) {
            return Byte.toString(object);
        }
    }

    private static final class CharacterConverter
    implements Converter<Character> {
        private CharacterConverter() {
        }

        @Override
        public Character toObject(String string) {
            return Character.valueOf(string.charAt(0));
        }

        @Override
        public String toString(Character object) {
            return Character.toString(object.charValue());
        }
    }

    private static final class DoubleConverter
    implements Converter<Double> {
        private DoubleConverter() {
        }

        @Override
        public Double toObject(String string) {
            return Double.parseDouble(string);
        }

        @Override
        public String toString(Double object) {
            return Double.toString(object);
        }
    }

    private static final class FloatConverter
    implements Converter<Float> {
        private FloatConverter() {
        }

        @Override
        public Float toObject(String string) {
            return Float.valueOf(Float.parseFloat(string));
        }

        @Override
        public String toString(Float object) {
            return Float.toString(object.floatValue());
        }
    }

    private static final class IntegerConverter
    implements Converter<Integer> {
        private IntegerConverter() {
        }

        @Override
        public Integer toObject(String string) {
            return Integer.parseInt(string);
        }

        @Override
        public String toString(Integer object) {
            return Integer.toString(object);
        }
    }

    private static final class LongConverter
    implements Converter<Long> {
        private LongConverter() {
        }

        @Override
        public Long toObject(String string) {
            return Long.parseLong(string);
        }

        @Override
        public String toString(Long object) {
            return Long.toString(object);
        }
    }

    private static final class ShortConverter
    implements Converter<Short> {
        private ShortConverter() {
        }

        @Override
        public Short toObject(String string) {
            return Short.parseShort(string);
        }

        @Override
        public String toString(Short object) {
            return Short.toString(object);
        }
    }

    private static final class StringConverter
    implements Converter<String> {
        private StringConverter() {
        }

        @Override
        public String toObject(String string) {
            return string;
        }

        @Override
        public String toString(String object) {
            return object;
        }
    }

    private static final class VoidConverter
    implements Converter<Void> {
        private VoidConverter() {
        }

        @Override
        public Void toObject(String string) {
            return null;
        }

        @Override
        public String toString(Void object) {
            return "";
        }
    }
}

