/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.licensing.core.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class Hardware4Nix {
    public static final String getSerialNumber() {
        String sn = null;
        if (sn == null) {
            sn = Hardware4Nix.readDmidecode();
        }
        if (sn == null) {
            sn = Hardware4Nix.readLshal();
        }
        if (sn == null) {
            sn = Hardware4Nix.readOtherInfos();
        }
        if (sn == null) {
            throw new RuntimeException("Cannot find computer SN");
        }
        String userName = System.getProperty("user.name");
        if (userName == null) {
            throw new RuntimeException("Cannot find computer user name");
        }
        return sn.toUpperCase() + "|" + userName.toUpperCase();
    }

    private static BufferedReader read(String[] command) {
        OutputStream os = null;
        InputStream is = null;
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec(command);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        os = process.getOutputStream();
        is = process.getInputStream();
        try {
            os.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new BufferedReader(new InputStreamReader(is));
    }

    private static String readDmidecode() {
        String sn;
        block13: {
            sn = null;
            String line = null;
            String marker = "Serial Number:";
            BufferedReader br = null;
            try {
                try {
                    br = Hardware4Nix.read("dmidecode -t system".split(" "));
                    while ((line = br.readLine()) != null) {
                        if (line.indexOf(marker) == -1) continue;
                        sn = line.split(marker)[1].trim();
                        break;
                    }
                }
                catch (Exception exception) {
                    if (br == null) break block13;
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return sn;
    }

    private static String readLshal() {
        String sn;
        block13: {
            sn = null;
            String line = null;
            String marker = "system.hardware.serial =";
            BufferedReader br = null;
            try {
                try {
                    br = Hardware4Nix.read("lshal".split(" "));
                    while ((line = br.readLine()) != null) {
                        if (line.indexOf(marker) == -1) continue;
                        sn = line.split(marker)[1].replaceAll("\\(string\\)|(\\')", "").trim();
                        break;
                    }
                }
                catch (Exception exception) {
                    if (br == null) break block13;
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return sn;
    }

    private static String readOtherInfos() {
        String sn;
        block13: {
            sn = null;
            String line = null;
            BufferedReader br = null;
            try {
                try {
                    br = Hardware4Nix.read(new String[]{"sh", "-c", "echo \"$(uname)|$(hostid)|$(stat -c '%i' ~)\""});
                    while ((line = br.readLine()) != null) {
                        sn = line;
                    }
                }
                catch (Exception exception) {
                    if (br == null) break block13;
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return sn;
    }
}

