/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.licensing.core.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Reflector {
    public static final <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... types) {
        try {
            return clazz.getConstructor(types);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static final <T> T newInstance(Class<T> clazz, Object ... args) {
        Constructor<T> ctor;
        Class[] types = null;
        if (args != null && args.length > 0) {
            types = new Class[args.length];
            int i = 0;
            while (i < args.length) {
                types[i] = args[i].getClass();
                ++i;
            }
        }
        if ((ctor = Reflector.getConstructor(clazz, types)) == null) {
            throw new IllegalArgumentException("Such constructor does not exist");
        }
        try {
            return ctor.newInstance(args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static final Object getValue(Field field, Object parent) {
        try {
            return field.get(parent);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public static final void setValue(Field field, Object parent, Object value) {
        try {
            field.set(parent, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public static final Object invoke(Method method, Object parent, Object ... args) {
        try {
            return method.invoke(parent, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static final Object invoke(String name, Class<?>[] types, Object parent, Object ... args) {
        Method method = null;
        try {
            method = parent.getClass().getMethod(name, types);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
        return Reflector.invoke(method, parent, args);
    }
}

