/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.licensing.core.product;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;

public class Product {
    private String name;
    private List<String> versions;

    public Product(String name, List<String> versions) {
        this.name = name;
        this.versions = new ArrayList<String>();
        this.versions.addAll(versions);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getVersions() {
        return this.versions;
    }

    public static Product fromJsonString(String jsonString) {
        Gson gson = new GsonBuilder().create();
        Product product = (Product)gson.fromJson(jsonString, Product.class);
        return product;
    }

    public String toJsonString() {
        Gson gson = new GsonBuilder().create();
        return gson.toJson((Object)this);
    }

    public void addVersion(String v) {
        if (!this.versions.contains(v)) {
            this.versions.add(v);
        }
    }

    public String toString() {
        return this.name + this.versions.toString();
    }
}

