/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.licensing.core.product;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.edgemind.ibee.licensing.core.product.Product;

public class ProductList {
    private List<Product> products;

    public ProductList() {
        this.products = new ArrayList<Product>();
    }

    public ProductList(List<Product> products) {
        this.products = products;
    }

    public List<Product> getProducts() {
        return this.products;
    }

    public void addProduct(Product p) {
        Optional<Product> op = this.products.stream().filter(pr -> pr.getName().equals(p.getName())).findFirst();
        if (op.isPresent()) {
            p.getVersions().stream().forEach(v -> ((Product)op.get()).addVersion((String)v));
        } else {
            this.products.add(p);
        }
    }

    public static ProductList fromJsonString(String jsonString) {
        Gson gson = new GsonBuilder().create();
        ProductList pl = (ProductList)gson.fromJson(jsonString, ProductList.class);
        return pl;
    }

    public String toJsonString() {
        Gson gson = new GsonBuilder().create();
        return gson.toJson((Object)this);
    }

    public String toString() {
        return this.products.stream().map(Product::toString).collect(Collectors.joining(", "));
    }
}

