/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.licensing.core.product;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Optional;
import net.edgemind.ibee.licensing.core.exception.InvalidLicenseException;
import net.edgemind.ibee.licensing.core.exception.LicenseReadingException;
import net.edgemind.ibee.licensing.core.hardwarekey.HardwareKeyHelper;
import net.edgemind.ibee.licensing.core.product.Product;
import net.edgemind.ibee.licensing.core.product.ProductList;
import net.edgemind.ibee.licensing.core.product.ProductsLicense;

public class ProductsLicenseValidationHelper {
    public static final String WILDCARD_CHAR = "*";

    private ProductsLicenseValidationHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static void isLicenseValid(ProductsLicense license, String productName, String productVersion) throws LicenseReadingException, InvalidLicenseException {
        boolean dateIsValid = ProductsLicenseValidationHelper.checkDate(license);
        if (!dateIsValid) {
            throw new InvalidLicenseException(InvalidLicenseException.InvalidLicenseReason.EXPIRATION_DATE_PASSED);
        }
        String localHardwareKey = HardwareKeyHelper.readHardwareKey((String)HardwareKeyHelper.getHardwareKey()).hardwareKey;
        String licenseHardwareKey = HardwareKeyHelper.readHardwareKey((String)license.sn).hardwareKey;
        boolean hkIsValid = localHardwareKey.equalsIgnoreCase(licenseHardwareKey);
        if (!hkIsValid) {
            throw new InvalidLicenseException(InvalidLicenseException.InvalidLicenseReason.UNRECOGNIZED_HOST);
        }
        boolean productValid = false;
        ProductList list = ProductList.fromJsonString(license.products);
        Optional<Product> oProduct = list.getProducts().stream().filter(p -> p.getName().equals(productName)).findFirst();
        if (oProduct.isPresent()) {
            for (String versionString : oProduct.get().getVersions()) {
                if (!ProductsLicenseValidationHelper.isVersionValid(productVersion, versionString)) continue;
                productValid = true;
                break;
            }
        }
        if (!productValid) {
            throw new InvalidLicenseException(InvalidLicenseException.InvalidLicenseReason.NO_VALID_PRODUCT);
        }
    }

    private static boolean checkDate(ProductsLicense license) throws LicenseReadingException {
        Date licenseDate;
        SimpleDateFormat sdformat = new SimpleDateFormat("dd/MM/yyyy");
        try {
            licenseDate = sdformat.parse(license.endDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new LicenseReadingException();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date now = calendar.getTime();
        return now.compareTo(licenseDate) <= 0;
    }

    public static boolean isVersionValid(String testedVersion, String compareToVersion) {
        testedVersion = testedVersion.split("\\-")[0];
        if ((compareToVersion = compareToVersion.split("\\-")[0]).equals(WILDCARD_CHAR)) {
            return true;
        }
        if (compareToVersion.equals(testedVersion)) {
            return true;
        }
        String[] testedVersionTokens = testedVersion.split("\\.");
        String[] compareToVersionTokens = compareToVersion.split("\\.");
        int maxSize = Math.max(testedVersionTokens.length, compareToVersionTokens.length);
        int i = 0;
        while (i < maxSize) {
            String compareToVersionToken;
            String testedVersionToken = i < testedVersionTokens.length ? testedVersionTokens[i] : WILDCARD_CHAR;
            String string = compareToVersionToken = i < compareToVersionTokens.length ? compareToVersionTokens[i] : WILDCARD_CHAR;
            if (testedVersionToken.equals(WILDCARD_CHAR) || compareToVersionToken.equals(WILDCARD_CHAR)) {
                return true;
            }
            if (!testedVersionToken.equals(compareToVersionToken)) {
                int compareVersionTokenValue;
                int testedVersionTokenValue = Integer.parseInt(testedVersionToken);
                return testedVersionTokenValue < (compareVersionTokenValue = Integer.parseInt(compareToVersionToken));
            }
            ++i;
        }
        return false;
    }
}

