/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.licensing.ui;

import net.edgemind.ibee.licensing.core.exception.InvalidLicenseException;
import net.edgemind.ibee.licensing.core.exception.LicenseReadingException;
import net.edgemind.ibee.licensing.core.product.ProductsLicense;
import net.edgemind.ibee.licensing.core.product.ProductsLicenseHelper;
import net.edgemind.ibee.licensing.core.product.ProductsLicenseValidationHelper;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class SoftwareLicenseCheckHelper {
    public static boolean checkLicense(Shell shell, String license, String productName, String productVersion, boolean showAcceptedMessage) {
        if (license == null || license.isEmpty()) {
            SoftwareLicenseCheckHelper.displayMessage(1, shell, "License is empty");
            return false;
        }
        try {
            ProductsLicenseValidationHelper.isLicenseValid((ProductsLicense)ProductsLicenseHelper.getToken((String)license), (String)productName, (String)productVersion);
        }
        catch (RuntimeException | LicenseReadingException throwable) {
            SoftwareLicenseCheckHelper.displayMessage(1, shell, "Can't decode license");
            return false;
        }
        catch (InvalidLicenseException e) {
            String displayedMessage = "";
            switch (e.getReason()) {
                case EXPIRATION_DATE_PASSED: {
                    displayedMessage = "License has expired";
                    break;
                }
                case NO_VALID_PRODUCT: {
                    displayedMessage = "License is not valid for this software";
                    break;
                }
                case UNRECOGNIZED_HOST: {
                    displayedMessage = "License is not valid for this computer/user";
                    break;
                }
            }
            SoftwareLicenseCheckHelper.displayMessage(1, shell, displayedMessage);
            return false;
        }
        if (showAcceptedMessage) {
            SoftwareLicenseCheckHelper.displayMessage(16, shell, "Accepted license");
        }
        return true;
    }

    private static void displayMessage(int iconError, Shell shell, String message) {
        if (shell == null) {
            shell = new Shell(0);
        }
        MessageBox messageBox = new MessageBox(shell, iconError);
        messageBox.setMessage(message);
        messageBox.open();
    }
}

