/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.licensing.ui;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.edgemind.ibee.licensing.core.hardwarekey.HardwareKeyHelper;
import net.edgemind.ibee.licensing.core.product.ProductList;
import net.edgemind.ibee.licensing.core.product.ProductsLicense;
import net.edgemind.ibee.licensing.core.product.ProductsLicenseHelper;
import net.edgemind.ibee.licensing.ui.SoftwareLicenseCheckHelper;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SoftwareLicenseDialog {
    private Shell shell;
    private Clipboard clipboard;
    private boolean isLicenseValid = false;
    private String license;
    private Text liValue;
    private String product;
    private String version;
    private Text dateInfoText;
    private Text productsInfoText;
    private Text userInfoText;

    public SoftwareLicenseDialog(String product, String version, String existingLicense) {
        this.product = product;
        this.version = version;
        this.license = existingLicense;
    }

    public void create(Shell parent) {
        this.shell = parent;
        this.shell.setText("License");
        this.clipboard = new Clipboard(this.shell.getDisplay());
        this.createCtrl((Composite)parent);
        this.shell.pack();
    }

    protected void createCtrl(Composite parent) {
        GridLayout shellLayout = new GridLayout();
        shellLayout.marginHeight = 15;
        shellLayout.marginWidth = 15;
        this.shell.setLayout((Layout)shellLayout);
        Group hardwareSerialNumberContainer = new Group(parent, 0);
        hardwareSerialNumberContainer.setText("Hardware Key");
        hardwareSerialNumberContainer.setLayout((Layout)new GridLayout(2, false));
        GridData hsnGridData = new GridData(1808);
        hardwareSerialNumberContainer.setLayoutData((Object)hsnGridData);
        hsnGridData.minimumHeight = 80;
        Text hsnValue = new Text((Composite)hardwareSerialNumberContainer, 66);
        hsnValue.setText(this.getHardwareKeyDisplayString());
        hsnValue.setEditable(false);
        hsnValue.setLayoutData((Object)new GridData(1808));
        Composite hsnButtonGroup = new Composite((Composite)hardwareSerialNumberContainer, 0);
        FillLayout hsnButtonGroupRowLayout = new FillLayout(512);
        hsnButtonGroup.setLayout((Layout)hsnButtonGroupRowLayout);
        GridData hsnButtonGroupGridData = new GridData();
        hsnButtonGroupGridData.widthHint = 160;
        hsnButtonGroupGridData.grabExcessHorizontalSpace = false;
        hsnButtonGroup.setLayoutData((Object)hsnButtonGroupGridData);
        Button hsnCopyValueButton = new Button(hsnButtonGroup, 0);
        hsnCopyValueButton.setText("Copy to clipboard");
        hsnCopyValueButton.addListener(13, e -> this.copyHardwareKeyToClipboard(HardwareKeyHelper.getHardwareKey()));
        Button hsnSaveValueButton = new Button(hsnButtonGroup, 0);
        hsnSaveValueButton.setText("Save key file");
        hsnSaveValueButton.addListener(13, e -> this.saveHardwareKeyToFile());
        Group licenseInputContainer = new Group(parent, 0);
        licenseInputContainer.setText("License");
        GridData liGridData = new GridData(1808);
        liGridData.minimumHeight = 80;
        licenseInputContainer.setLayoutData((Object)liGridData);
        licenseInputContainer.setLayout((Layout)new GridLayout(2, false));
        this.liValue = new Text((Composite)licenseInputContainer, 66);
        GridData liValueGridData = new GridData(1808);
        liValueGridData.widthHint = 600;
        this.liValue.setLayoutData((Object)liValueGridData);
        Composite licenceButtonGroup = new Composite((Composite)licenseInputContainer, 0);
        FillLayout licenceButtonGroupRowLayout = new FillLayout(512);
        licenceButtonGroup.setLayout((Layout)licenceButtonGroupRowLayout);
        GridData licenceButtonGroupGridData = new GridData();
        licenceButtonGroupGridData.widthHint = 160;
        licenceButtonGroup.setLayoutData((Object)licenceButtonGroupGridData);
        Button licencePastValueButton = new Button(licenceButtonGroup, 0);
        licencePastValueButton.setText("Paste from clipboard");
        licencePastValueButton.addListener(13, e -> this.loadLicenceFromClipboard());
        Button loadFileValueButton = new Button(licenceButtonGroup, 0);
        loadFileValueButton.setText("Load license file");
        loadFileValueButton.addListener(13, e -> this.loadLicenceFromFile());
        Group licenseInfoContainer = new Group(parent, 0);
        GridData liInfoGridData = new GridData(1808);
        liInfoGridData.minimumHeight = 80;
        licenseInfoContainer.setLayoutData((Object)liInfoGridData);
        licenseInfoContainer.setLayout((Layout)new GridLayout(2, false));
        new Label((Composite)licenseInfoContainer, 0).setText("Date :");
        this.dateInfoText = new Text((Composite)licenseInfoContainer, 0);
        this.dateInfoText.setLayoutData((Object)new GridData(768));
        new Label((Composite)licenseInfoContainer, 0).setText("Products :");
        this.productsInfoText = new Text((Composite)licenseInfoContainer, 0);
        this.productsInfoText.setLayoutData((Object)new GridData(768));
        new Label((Composite)licenseInfoContainer, 0).setText("User :");
        this.userInfoText = new Text((Composite)licenseInfoContainer, 0);
        this.userInfoText.setLayoutData((Object)new GridData(768));
        Composite bottomButtonsBar = new Composite(parent, 0);
        GridData gridData = new GridData(128);
        bottomButtonsBar.setLayoutData((Object)gridData);
        bottomButtonsBar.setLayout((Layout)new GridLayout(2, false));
        Button btnCancel = new Button(bottomButtonsBar, 0);
        btnCancel.setText("Decline");
        btnCancel.addListener(13, e -> this.shell.close());
        Button btnDone = new Button(bottomButtonsBar, 0);
        gridData.grabExcessHorizontalSpace = true;
        btnDone.setLayoutData((Object)gridData);
        btnDone.setText("Validate");
        btnDone.addListener(13, e -> this.checkLicence(this.liValue.getText()));
        if (this.license != null && !this.license.isEmpty()) {
            this.liValue.setText(this.license);
            this.displayInfos();
        }
    }

    private void displayInfos() {
        try {
            ProductsLicense productsLicense = ProductsLicenseHelper.getToken((String)this.license);
            ProductList list = ProductList.fromJsonString((String)productsLicense.products);
            this.dateInfoText.setText(productsLicense.endDate);
            this.productsInfoText.setText(list.toString());
            this.userInfoText.setText(HardwareKeyHelper.getUserFromKey((String)productsLicense.sn));
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private void copyHardwareKeyToClipboard(String hardwareKey) {
        TextTransfer textTransfer = TextTransfer.getInstance();
        this.clipboard.setContents(new Object[]{hardwareKey}, new Transfer[]{textTransfer});
    }

    private void loadLicenceFromClipboard() {
        TextTransfer textTransfer = TextTransfer.getInstance();
        String textData = (String)this.clipboard.getContents((Transfer)textTransfer);
        if (textData != null) {
            this.liValue.setText(textData);
        }
    }

    private void saveHardwareKeyToFile() {
        FileDialog dialog = new FileDialog(this.shell, 8192);
        dialog.setOverwrite(true);
        dialog.setText("Save Hardware Key");
        dialog.setFileName(System.getProperty("user.name") + "_andromeda_in.lic");
        String[] filterExt = new String[]{"*.lic"};
        dialog.setFilterExtensions(filterExt);
        String homefolder = System.getProperty("user.home");
        dialog.setFilterPath(homefolder);
        String filePath = dialog.open();
        if (filePath == null) {
            return;
        }
        Path path = Paths.get(filePath, new String[0]);
        try {
            Files.write(path, HardwareKeyHelper.getHardwareKey().getBytes(), new OpenOption[0]);
        }
        catch (IOException iOException) {
            MessageBox messageBox = new MessageBox(this.shell, 1);
            messageBox.setMessage("Can't save hardware key into " + filePath);
            messageBox.open();
        }
    }

    private void loadLicenceFromFile() {
        FileDialog dialog = new FileDialog(this.shell, 4096);
        dialog.setText("Open License File");
        String[] filterExt = new String[]{"*.lic"};
        dialog.setFilterExtensions(filterExt);
        String homefolder = System.getProperty("user.home");
        dialog.setFilterPath(homefolder);
        String filePath = dialog.open();
        if (filePath == null) {
            return;
        }
        Path path = Paths.get(filePath, new String[0]);
        try {
            String read = Files.readAllLines(path).get(0);
            this.liValue.setText(read);
        }
        catch (IOException iOException) {
            MessageBox messageBox = new MessageBox(this.shell, 1);
            messageBox.setMessage("Can't read license file from " + filePath);
            messageBox.open();
        }
    }

    private void checkLicence(String license) {
        this.isLicenseValid = SoftwareLicenseCheckHelper.checkLicense(this.shell, license, this.product, this.version, true);
        if (this.isLicenseValid) {
            this.license = license;
            this.shell.close();
        }
    }

    private String getHardwareKeyDisplayString() {
        return "User : " + System.getProperty("user.name") + System.lineSeparator() + "Key : " + HardwareKeyHelper.getHardwareKey();
    }

    public boolean isLicenseValid() {
        return this.isLicenseValid;
    }

    public String getLicense() {
        return this.license;
    }
}

