/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.app;

import net.edgemind.ibee.core.app.IPart;
import net.edgemind.ibee.core.app.IResourceAction;
import net.edgemind.ibee.core.command.CommandStack;
import net.edgemind.ibee.core.command.ExecutionException;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.edit.RecordCommand;

public abstract class ResourceAction
implements IResourceAction {
    private static final long serialVersionUID = 1L;
    IbeeResource resource;
    CommandStack cmdStack;

    public ResourceAction(IbeeResource resource, CommandStack cmdStack) {
        this.resource = resource;
        this.cmdStack = cmdStack;
    }

    public void executeRecordedWithoutError(IPart part) {
        try {
            this.executeRecorded(part);
        }
        catch (ExecutionException e) {
            LogUtil.log(e);
        }
    }

    @Override
    public void executeRecorded(final IPart part) throws ExecutionException {
        CommandStack stack = this.cmdStack;
        if (stack == null) {
            stack = this.resource.getEditingDomain().getCommandStack();
        }
        stack.execute(new RecordCommand(this.resource){

            @Override
            protected void executeRecorded() throws ExecutionException {
                ResourceAction.this.execute(part);
            }
        });
    }
}

