/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.command;

import net.edgemind.ibee.core.command.CommandStack;
import net.edgemind.ibee.core.command.ExecutionException;
import net.edgemind.ibee.core.command.IResourceCommand;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.edit.RecordCommand;

public abstract class ResourceCommand
implements IResourceCommand {
    private static final long serialVersionUID = 1L;
    private CommandStack cmdStack;

    public ResourceCommand() {
        this.cmdStack = null;
    }

    public ResourceCommand(CommandStack cmdStack) {
        this.cmdStack = cmdStack;
    }

    public void executeRecordedWithoutError(IbeeResource resource) {
        try {
            this.executeRecorded(resource);
        }
        catch (ExecutionException e) {
            LogUtil.log(e);
        }
    }

    @Override
    public void executeRecorded(IbeeResource resource) throws ExecutionException {
        ResourceCommand cmd;
        CommandStack stack = this.cmdStack;
        if (stack == null) {
            stack = resource.getEditingDomain().getCommandStack();
        }
        if ((cmd = this) instanceof RecordCommand) {
            stack.execute((RecordCommand)((Object)cmd));
        } else {
            stack.execute(new RecordCommand(resource){

                @Override
                protected void executeRecorded() throws ExecutionException {
                    ResourceCommand.this.execute();
                }
            });
        }
    }
}

