/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.diagram;

import java.io.Serializable;

public class Color
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static Color RED = new Color(255, 0, 0);
    public static Color GREEN = new Color(0, 255, 0);
    public static Color BLUE = new Color(0, 0, 255);
    public static Color WHITE = new Color(255, 255, 255);
    public static Color BLACK = new Color(0, 0, 0);
    public static Color YELLOW = new Color(255, 255, 0);
    public static Color GRAY = new Color(50, 50, 50);
    public static Color GRAY_BRIGHT = new Color(200, 200, 200);
    public static Color EMBLUE = new Color(34, 65, 108);
    public static Color EMORANGE = new Color(244, 126, 36);
    public static Color EMGRAY = new Color(207, 208, 218);
    public static Color EMBROWNLIGHT = new Color(172, 124, 71);
    public static Color EMRED = new Color(173, 36, 35);
    public static Color EMBROWN = new Color(94, 19, 19);
    int r = 0;
    int g = 0;
    int b = 0;
    int t = 0;

    public Color() {
    }

    public Color(String rgb) {
        this();
        this.r = 0xFF & Integer.parseInt(rgb, 16) >> 16;
        this.g = 0xFF & Integer.parseInt(rgb, 16) >> 8;
        this.b = 0xFF & Integer.parseInt(rgb, 16);
    }

    public Color(int r, int g, int b) {
        this();
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public static Color fromHex(String hex) {
        if (hex.length() < 7) {
            return null;
        }
        return new Color(Integer.parseInt(hex.substring(1, 3), 16), Integer.parseInt(hex.substring(3, 5), 16), Integer.parseInt(hex.substring(5, 7), 16));
    }

    public Color(int r, int g, int b, int t) {
        this();
        this.r = r;
        this.g = g;
        this.b = b;
        this.t = t;
    }

    public int getR() {
        return this.r;
    }

    public int getG() {
        return this.g;
    }

    public int getB() {
        return this.b;
    }

    public int getT() {
        return this.t;
    }

    public int hashCode() {
        Integer i = this.r + this.g + this.b + this.t;
        return i.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Color) {
            Color otherColor = (Color)other;
            return this.getR() == otherColor.getR() && this.getG() == otherColor.getG() && this.getB() == otherColor.getB() && this.getT() == otherColor.getT();
        }
        return false;
    }
}

