/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.diagram;

import java.util.Map;
import net.edgemind.ibee.core.app.Event;
import net.edgemind.ibee.core.app.IEventHandler;
import net.edgemind.ibee.core.diagram.Color;
import net.edgemind.ibee.core.diagram.DiagramData;
import net.edgemind.ibee.util.math.Frame;
import net.edgemind.ibee.util.math.Point2D;
import net.edgemind.ibee.util.misc.ClassUtil;

public abstract class DElement {
    protected Object element;
    private DiagramData data;
    protected Map<Class<?>, IEventHandler<?>> eventHandler;
    protected boolean antiScaleX = false;
    protected boolean antiScaleY = false;
    protected double deltaScreenX = 0.0;
    protected double deltaScreenY = 0.0;
    protected Color foreColor = Color.BLACK;
    protected Color backColor = Color.WHITE;
    protected Positioning positioning = Positioning.Absolute;

    public <T extends Event> void setHandler(IEventHandler<T> handler, Class<T> clazz) {
        this.eventHandler.put(clazz, handler);
    }

    public <T extends Event> IEventHandler<T> getEventHandler(Class<T> clazz) {
        return this.eventHandler.get(clazz);
    }

    public abstract Frame getSize();

    public Object getElement() {
        return this.element;
    }

    public <T> T getElement(Class<T> clazz) {
        if (this.element == null) {
            return null;
        }
        if (ClassUtil.inherits(this.element.getClass(), clazz)) {
            return (T)this.element;
        }
        return null;
    }

    public void setElement(Object element) {
        this.element = element;
    }

    public DiagramData getData() {
        return this.getData(false);
    }

    public DiagramData getData(boolean create) {
        if (this.data == null && create) {
            this.data = new DiagramData();
        }
        return this.data;
    }

    public void setData(DiagramData data) {
        this.data = data;
    }

    public Object getData(String key) {
        return this.data != null ? this.data.getValue(key) : null;
    }

    public <T> T getData(Class<T> clazz) {
        return this.data != null ? (T)this.data.getValue(clazz) : null;
    }

    public void setData(String key, Object value) {
        this.getData(true).setValue(key, value);
    }

    public <K, V extends K> void setData(Class<K> clazz, V value) {
        this.getData(true).setValue(clazz, value);
    }

    public boolean doAntiScaleX() {
        return this.antiScaleX;
    }

    public boolean doAntiScaleY() {
        return this.antiScaleY;
    }

    public void doAntiScaleX(boolean value) {
        this.antiScaleX = value;
    }

    public void doAntiScaleY(boolean value) {
        this.antiScaleY = value;
    }

    public Positioning getPositioning() {
        return this.positioning;
    }

    public void setPositioning(Positioning positioning) {
        this.positioning = positioning;
    }

    public void setDeltaScreenX(double x) {
        this.deltaScreenX = x;
    }

    public void setDeltaScreenY(double y) {
        this.deltaScreenY = y;
    }

    public double getDeltaScreenX() {
        return this.deltaScreenX;
    }

    public double getDeltaScreenY() {
        return this.deltaScreenY;
    }

    public void setForeColor(Color c) {
        this.foreColor = c;
    }

    public Color getForeColor() {
        return this.foreColor;
    }

    public void setBackColor(Color c) {
        this.backColor = c;
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public Frame getFrame() {
        return this.getSize();
    }

    public double getHeight() {
        return this.getSize().getHeight();
    }

    public double getWidth() {
        return this.getSize().getWidth();
    }

    public double getX() {
        return this.getSize().getX();
    }

    public double getY() {
        return this.getSize().getY();
    }

    public Point2D getCenter() {
        return this.getSize().getCenter();
    }

    public Point2D getNorth() {
        return this.getSize().getNorth();
    }

    public Point2D getSouth() {
        return this.getSize().getSouth();
    }

    public Point2D getWest() {
        return this.getSize().getWest();
    }

    public Point2D getEast() {
        return this.getSize().getEast();
    }

    public Point2D getNorthWest() {
        return this.getSize().getNorthWest();
    }

    public Point2D getNorthEast() {
        return this.getSize().getNorthEast();
    }

    public Point2D getSouthWest() {
        return this.getSize().getSouthWest();
    }

    public Point2D getSouthEast() {
        return this.getSize().getSouthEast();
    }

    public static interface EventHandler {
        public void handle(Event var1);
    }

    public static enum Positioning {
        Absolute,
        Relative,
        Viewer;

    }
}

