/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.diagram;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jsinterop.annotations.JsType;
import net.edgemind.ibee.core.diagram.DElement;
import net.edgemind.ibee.core.diagram.Group;
import net.edgemind.ibee.util.math.Frame;

@JsType(namespace="ui")
public class Diagram
extends DElement
implements Serializable {
    private Frame lastFrame;
    private static final long serialVersionUID = 1L;
    private List<Group> groups;

    public void addGroup(Group g) {
        if (this.groups == null) {
            this.groups = new ArrayList<Group>();
        }
        this.groups.add(g);
    }

    public List<Group> getGroups() {
        if (this.groups == null) {
            return new ArrayList<Group>();
        }
        return this.groups;
    }

    @Override
    public Frame getSize() {
        return this.getSize(false);
    }

    public Frame getSize(boolean refresh) {
        if (!refresh && this.lastFrame != null) {
            return this.lastFrame;
        }
        Frame frame = null;
        if (this.groups != null) {
            for (Group group : this.groups) {
                Frame other = group.getSize();
                if (frame == null) {
                    frame = other;
                    continue;
                }
                if (other == null) continue;
                frame.expand(other);
            }
        }
        if (frame == null) {
            frame = new Frame();
        }
        this.lastFrame = frame;
        return frame;
    }

    public void setSize(Frame frame) {
        this.lastFrame = frame;
    }
}

