/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.diagram;

import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.core.diagram.Color;
import net.edgemind.ibee.core.diagram.DElement;
import net.edgemind.ibee.core.diagram.Point;
import net.edgemind.ibee.util.math.Frame;

public class Edge
extends DElement {
    private DElement src;
    private DElement target;
    private ArrowType arrowType = ArrowType.NONE;
    private LineStyle lineStyle = LineStyle.NORMAL;
    private LineAlgo lineAlgo = LineAlgo.DIRECT;
    private double dashLength = -1.0;
    private double dashLineLength = -1.0;
    private double lineWidth = 1.0;
    private List<Point> points;
    private Color foreColor = Color.BLACK;

    public Edge() {
    }

    public Edge(Edge toClone) {
        this.src = toClone.getSource();
        this.target = toClone.getTarget();
        this.lineWidth = toClone.getLineWidth();
        this.arrowType = toClone.getArrowType();
        List<Point> points = toClone.getPoints();
        if (points != null) {
            this.points = new ArrayList<Point>(points);
        }
        this.foreColor = toClone.getForeColor();
    }

    public double getDashLength() {
        return this.dashLength;
    }

    public void setDashLength(double dashLength) {
        this.dashLength = dashLength;
    }

    public double getDashLineLength() {
        return this.dashLineLength;
    }

    public void setDashLineLength(double dashLineLength) {
        this.dashLineLength = dashLineLength;
    }

    public void setSource(DElement src) {
        this.src = src;
    }

    public void setTarget(DElement target) {
        this.target = target;
    }

    public DElement getSource() {
        return this.src;
    }

    public DElement getTarget() {
        return this.target;
    }

    @Override
    public void setForeColor(Color c) {
        this.foreColor = c;
    }

    @Override
    public Color getForeColor() {
        return this.foreColor;
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public void setPoints(List<Point> points) {
        this.points = points;
    }

    public void setPoints(Point[] points) {
        this.points = new ArrayList<Point>();
        Point[] pointArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            Point point = pointArray[n2];
            this.points.add(point);
            ++n2;
        }
    }

    public void setArrowType(ArrowType arrowType) {
        this.arrowType = arrowType;
    }

    public ArrowType getArrowType() {
        return this.arrowType;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void setLineStyle(LineStyle style) {
        this.lineStyle = style;
    }

    public LineStyle getLineStyle() {
        return this.lineStyle;
    }

    public void setLineAlgo(LineAlgo algo) {
        this.lineAlgo = algo;
    }

    public LineAlgo getLineAlgo() {
        return this.lineAlgo;
    }

    @Override
    public Frame getSize() {
        return null;
    }

    public static enum ArrowType {
        NONE,
        ARROW_TARGET;

    }

    public static enum LineAlgo {
        DIRECT,
        BEZIER;

    }

    public static enum LineStyle {
        NORMAL,
        DASH;

    }
}

