/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.diagram;

import net.edgemind.ibee.core.diagram.Color;
import net.edgemind.ibee.core.diagram.DElement;
import net.edgemind.ibee.util.math.Frame;

public class Text
extends DElement {
    private String text;
    private double x;
    private double y;
    private double w;
    private double h;
    private double rotation;
    private FontType fontType = FontType.OPENSANS;
    private FontStyle fontStyle = FontStyle.NORMAL;
    private TextAlign textAlign = TextAlign.LEFT;
    private TextAlignV textAlignV = TextAlignV.TOP;
    private TextSizeType textSizeType = TextSizeType.PIXEL;
    private Overflow overflow = Overflow.PRINT_DOTS_LAST_WHITE_SPACE;
    private double textSize = 10.0;
    private double lineSpacing = 0.8;

    public Text() {
        super.setForeColor(Color.BLACK);
        super.setBackColor(null);
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setX(double x) {
        this.x = x;
    }

    @Override
    public double getX() {
        return this.x;
    }

    public void setY(double y) {
        this.y = y;
    }

    @Override
    public double getY() {
        return this.y;
    }

    public void setWidth(double w) {
        this.w = w;
    }

    @Override
    public double getWidth() {
        return this.w;
    }

    public void setHeight(double h) {
        this.h = h;
    }

    @Override
    public double getHeight() {
        return this.h;
    }

    @Override
    public Frame getFrame() {
        return new Frame(this.x, this.y, this.w, this.h);
    }

    public double getTextSize() {
        return this.textSize;
    }

    public void setTextSize(double textSize) {
        this.textSize = textSize;
    }

    public void setTextAlign(TextAlign textAlign) {
        this.textAlign = textAlign;
    }

    public TextAlign getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlignV(TextAlignV textAlignV) {
        this.textAlignV = textAlignV;
    }

    public TextAlignV getTextAlignV() {
        return this.textAlignV;
    }

    public FontType getFontType() {
        return this.fontType;
    }

    public void setFontType(FontType fontType) {
        this.fontType = fontType;
    }

    public FontStyle getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(FontStyle fontStyle) {
        this.fontStyle = fontStyle;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setRotation(double rotation) {
        this.rotation = rotation;
    }

    public void setTextsizeType(TextSizeType type) {
        this.textSizeType = type;
    }

    public TextSizeType getTextsizeType() {
        return this.textSizeType;
    }

    public double getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(double lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    public Overflow getOverflow() {
        return this.overflow;
    }

    public void setOverflow(Overflow overflow) {
        this.overflow = overflow;
    }

    @Override
    public Frame getSize() {
        Frame frame = new Frame(this.x, this.y, this.w, this.h);
        return frame;
    }

    public static enum FontStyle {
        ITALIC,
        NORMAL,
        BOLD;

    }

    public static enum FontType {
        OPENSANS,
        COURIER;

    }

    public static enum Overflow {
        PRINT_DOTS,
        PRINT_DOTS_LAST_WHITE_SPACE,
        HIDE,
        SHOW;

    }

    public static enum TextAlign {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static enum TextAlignV {
        TOP,
        CENTER,
        BOTTOM;

    }

    public static enum TextSizeType {
        POINTS,
        PIXEL;

    }
}

