/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.diagram.util;

import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.util.math.Line;
import net.edgemind.ibee.util.math.MathUtil;
import net.edgemind.ibee.util.math.Point2D;

public class CrossingLineAvoider {
    private List<List<Line>> lineSets = new ArrayList<List<Line>>();
    private double distance = 4.0;

    public void clear() {
        this.lineSets.clear();
    }

    public List<Line> clone(List<Line> line) {
        ArrayList<Line> clone = new ArrayList<Line>();
        for (Line part : line) {
            Line clonePart = part.clone();
            clone.add(clonePart);
        }
        return clone;
    }

    public List<Line> addLine(List<Line> line) {
        ArrayList<Line> bridgedSegments = new ArrayList<Line>();
        for (List<Line> existingLine : this.lineSets) {
            for (Line existingSegment : existingLine) {
                ArrayList<Line> bridgedLine = new ArrayList<Line>(line);
                line.clear();
                for (Line segment : bridgedLine) {
                    if (bridgedSegments.contains(segment)) {
                        line.add(segment);
                        continue;
                    }
                    Point2D p = MathUtil.getLineIntersectionCut((Line)segment, (Line)existingSegment);
                    if (p != null) {
                        List<Line> bridge = this.createBridge(p, segment, existingSegment);
                        if (bridge == null) {
                            line.add(segment);
                            continue;
                        }
                        for (Line next : bridge) {
                            line.add(next);
                        }
                        if (bridge.size() != 5) continue;
                        bridgedSegments.add(bridge.get(1));
                        bridgedSegments.add(bridge.get(2));
                        bridgedSegments.add(bridge.get(3));
                        continue;
                    }
                    line.add(segment);
                }
            }
        }
        ArrayList<Line> lineToAvoid = new ArrayList<Line>();
        for (Line segment : line) {
            if (bridgedSegments.contains(segment)) continue;
            lineToAvoid.add(segment);
        }
        this.lineSets.add(lineToAvoid);
        return line;
    }

    private List<Line> createBridge(Point2D p, Line segment, Line otherSegment) {
        Point2D p0 = new Point2D(segment.getX1(), segment.getY1());
        Point2D p5 = new Point2D(segment.getX2(), segment.getY2());
        double test = MathUtil.getPointPointDistance((Point2D)p0, (Point2D)p);
        if (test <= this.distance) {
            return null;
        }
        test = MathUtil.getPointPointDistance((Point2D)p5, (Point2D)p);
        if (test <= this.distance) {
            return null;
        }
        test = MathUtil.getPointPointDistance((Point2D)new Point2D(otherSegment.getX1(), otherSegment.getY1()), (Point2D)p);
        if (test <= this.distance) {
            return null;
        }
        test = MathUtil.getPointPointDistance((Point2D)new Point2D(otherSegment.getX2(), otherSegment.getY2()), (Point2D)p);
        if (test <= this.distance) {
            return null;
        }
        Point2D p1 = MathUtil.movePoint((Point2D)p, (Point2D)p0, (double)this.distance);
        Point2D p4 = MathUtil.movePoint((Point2D)p, (Point2D)p5, (double)this.distance);
        Point2D p2 = MathUtil.movePoint((Point2D)p1, (Point2D)p0, (double)120.0, (double)this.distance);
        Point2D p3 = MathUtil.movePoint((Point2D)p4, (Point2D)p5, (double)-120.0, (double)this.distance);
        ArrayList<Line> result = new ArrayList<Line>();
        result.add(new Line(p0.getX(), p0.getY(), p1.getX(), p1.getY()));
        result.add(new Line(p1.getX(), p1.getY(), p2.getX(), p2.getY()));
        result.add(new Line(p2.getX(), p2.getY(), p3.getX(), p3.getY()));
        result.add(new Line(p3.getX(), p3.getY(), p4.getX(), p4.getY()));
        result.add(new Line(p4.getX(), p4.getY(), p5.getX(), p5.getY()));
        return result;
    }
}

