/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.diagram.util;

import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.core.diagram.Edge;
import net.edgemind.ibee.core.diagram.Point;
import net.edgemind.ibee.util.math.Frame;
import net.edgemind.ibee.util.math.Line;
import net.edgemind.ibee.util.math.MathUtil;
import net.edgemind.ibee.util.math.Point2D;

public class DiagramEdgeRenderHelper {
    public List<Point> getPoints(Edge edge) {
        Frame f;
        double y2;
        double x2;
        double y1;
        double x1;
        Line l;
        Point2D intersection;
        List<Point> points = this.getEdgePoints(edge);
        if (edge.getSource() != null && edge.getLineAlgo() == Edge.LineAlgo.DIRECT && edge.getArrowType() == Edge.ArrowType.ARROW_TARGET && (intersection = MathUtil.getIntersection((Line)(l = new Line(x1 = points.get(0).getX(), y1 = points.get(0).getY(), x2 = points.get(1).getX(), y2 = points.get(1).getY())), (Frame)(f = edge.getSource().getFrame()))) != null) {
            points.get(0).setX(intersection.getX());
            points.get(0).setY(intersection.getY());
        }
        if (edge.getTarget() != null && edge.getLineAlgo() == Edge.LineAlgo.DIRECT && edge.getArrowType() == Edge.ArrowType.ARROW_TARGET) {
            x1 = points.get(points.size() - 2).getX();
            y1 = points.get(points.size() - 2).getY();
            x2 = points.get(points.size() - 1).getX();
            y2 = points.get(points.size() - 1).getY();
            f = edge.getTarget().getFrame();
            if (edge.getArrowType() == Edge.ArrowType.ARROW_TARGET) {
                f.setX(f.getX() - 10.0);
                f.setY(f.getY() - 10.0);
                f.setWidth(f.getWidth() + 20.0);
                f.setHeight(f.getHeight() + 20.0);
            }
            if ((intersection = MathUtil.getIntersection((Line)(l = new Line(x1, y1, x2, y2)), (Frame)f)) != null) {
                points.get(points.size() - 1).setX(intersection.getX());
                points.get(points.size() - 1).setY(intersection.getY());
            }
        }
        return points;
    }

    public List<Point> getEdgePoints(Edge e) {
        return this.getEdgePoints(e, 0.0, 0.0);
    }

    public List<Point> getEdgePoints(Edge e, double deltaX, double deltaY) {
        ArrayList<Point> points = new ArrayList<Point>();
        List<Point> pointsInner = e.getPoints();
        if (pointsInner == null && e.getSource() != null) {
            points.add(new Point(deltaX + e.getSource().getX() + e.getSource().getWidth() / 2.0, deltaY + e.getSource().getY() + e.getSource().getHeight() / 2.0));
        }
        if (pointsInner != null) {
            for (Point p : pointsInner) {
                points.add(new Point(p.getX() + deltaX, p.getY() + deltaY));
            }
        }
        if (pointsInner == null && e.getTarget() != null) {
            points.add(new Point(deltaX + e.getTarget().getX() + e.getTarget().getWidth() / 2.0, deltaY + e.getTarget().getY() + e.getTarget().getHeight() / 2.0));
        }
        return points;
    }
}

