/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.diagram.util;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.edgemind.ibee.core.diagram.DElement;
import net.edgemind.ibee.core.diagram.Diagram;
import net.edgemind.ibee.core.diagram.Group;
import net.edgemind.ibee.core.diagram.Text;
import net.edgemind.ibee.util.misc.IFilter;
import net.edgemind.ibee.util.string.PatternUtil;

public class DiagramElementsFinder {
    public List<Text> findTextsByPattern(String value, Diagram diagram) {
        ArrayList<Text> texts = new ArrayList<Text>();
        if (diagram == null) {
            return texts;
        }
        for (Group group : diagram.getGroups()) {
            texts.addAll(this.findTextsByPattern(value, group));
        }
        return texts;
    }

    public List<Text> findTextsByPattern(String value, Group group) {
        return this.findTextsByFilter(value, group, (IFilter<Text>)((IFilter)e -> PatternUtil.wildCardMatch((String)e.getText().toLowerCase(), (String)value.toLowerCase())));
    }

    public List<Text> findTextsByFilter(String value, Diagram diagram, IFilter<Text> filter) {
        ArrayList<Text> texts = new ArrayList<Text>();
        for (Group group : diagram.getGroups()) {
            texts.addAll(this.findTextsByFilter(value, group, filter));
        }
        return texts;
    }

    public List<Text> findTextsByFilter(String value, Group group, IFilter<Text> filter) {
        ArrayList<Text> matchingTexts = new ArrayList<Text>();
        this.findElementsByFilter(value, group, filter, matchingTexts);
        return matchingTexts;
    }

    private void findElementsByFilter(String value, Group group, IFilter<Text> filter, List<Text> matchingTexts) {
        for (Text text : group.getTexts()) {
            String textValue;
            if (value == null || value.length() == 0 || (textValue = text.getText()) == null || !filter.accept((Object)text)) continue;
            matchingTexts.add(text);
        }
        for (Group sub : group.getGroups()) {
            this.findElementsByFilter(value, sub, filter, matchingTexts);
        }
    }

    public List<Object> findElementsByFilter(String value, Group group, IFilter<Text> filter) {
        List<Text> texts = this.findTextsByFilter(value, group, filter);
        return this.getElementsFromTexts(texts);
    }

    public List<Object> getElementsFromTexts(List<Text> texts) {
        return texts.stream().map(DElement::getElement).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new)).stream().collect(Collectors.toList());
    }
}

