/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.diagram.util;

import net.edgemind.ibee.core.diagram.Text;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public class DiagramGCUtil {
    public static void applyDefaultOption(GC gc) {
        gc.setAdvanced(true);
        gc.setAntialias(1);
        gc.setTextAntialias(1);
    }

    public static Font applyFont(GC gc, Text text, Display display) {
        int style = 0;
        if (text.getFontStyle() == Text.FontStyle.BOLD) {
            style = 1;
        } else if (text.getFontStyle() == Text.FontStyle.ITALIC) {
            style = 2;
        }
        Font font = text.getTextsizeType() == Text.TextSizeType.PIXEL ? new Font(gc.getDevice(), "Arial Narrow", DiagramGCUtil.getTextsizeFromPixels(text.getTextSize(), display), style) : new Font(gc.getDevice(), "Arial Narrow", DiagramGCUtil.getTextsizeFromPoints(text.getTextSize()), style);
        gc.setFont(font);
        return font;
    }

    private static int getTextsizeFromPixels(double pixels, Display display) {
        double points72 = pixels * 72.0 / (double)display.getDPI().y;
        int i = (int)Math.round(points72);
        return i;
    }

    private static int getTextsizeFromPoints(double points72) {
        return (int)Math.round(points72);
    }
}

