/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.diagram.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.edgemind.ibee.core.diagram.Color;
import net.edgemind.ibee.core.diagram.DElement;
import net.edgemind.ibee.core.diagram.Diagram;
import net.edgemind.ibee.core.diagram.Edge;
import net.edgemind.ibee.core.diagram.Group;
import net.edgemind.ibee.core.diagram.Node;
import net.edgemind.ibee.core.diagram.Point;
import net.edgemind.ibee.core.diagram.Symbol;
import net.edgemind.ibee.core.diagram.Text;
import net.edgemind.ibee.core.diagram.primitives.PArc;
import net.edgemind.ibee.core.diagram.primitives.PCircle;
import net.edgemind.ibee.core.diagram.primitives.PImage;
import net.edgemind.ibee.core.diagram.primitives.PLine;
import net.edgemind.ibee.core.diagram.primitives.PPolyline;
import net.edgemind.ibee.core.diagram.primitives.PRect;
import net.edgemind.ibee.core.diagram.primitives.Primitive;
import net.edgemind.ibee.core.diagram.util.DiagramArrowRenderHelper;
import net.edgemind.ibee.core.diagram.util.DiagramEdgeRenderHelper;
import net.edgemind.ibee.core.diagram.util.DiagramGCUtil;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.util.file.FileUtil;
import net.edgemind.ibee.util.math.Frame;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGDiagramPrinter {
    private Document svgDocument;
    private GC gc;
    private Display display;
    public static double SCALE_X = 1.0;
    public static double SCALE_Y = 1.0;
    public static double BORDER_X = 20.0;
    public static double BORDER_Y = 40.0;

    public void printDiagram(Diagram diagram, File file) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (OutputStream out = FileUtil.openOutputStream((File)file);){
                this.printDiagram(diagram, out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IbeeException(e);
        }
    }

    public void printDiagram(Diagram diagram, String fileName) {
        this.printDiagram(diagram, new File(fileName));
    }

    public void printDiagram(Diagram diagram, OutputStream out) {
        this.createSvg(diagram);
        this.printSvg(out);
    }

    private void createCGDiagram(double imgWidth, double imgHeight) {
        this.display = this.getDisplay();
        Image diagramImage = new Image((Device)this.display, (int)imgWidth, (int)imgHeight);
        this.gc = new GC((Drawable)diagramImage);
        DiagramGCUtil.applyDefaultOption(this.gc);
    }

    private Display getDisplay() {
        Display display = Display.getDefault();
        if (display == null) {
            display = new Display();
        }
        return display;
    }

    public void createSvg(Diagram diagram) {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            this.svgDocument = docBuilder.newDocument();
            Element rootElement = this.svgDocument.createElement("svg");
            Frame diagFrame = diagram.getSize(true);
            rootElement.setAttribute("width", "" + (diagFrame.getWidth() + BORDER_X * 2.0));
            rootElement.setAttribute("height", "" + (diagFrame.getHeight() + BORDER_Y * 2.0));
            rootElement.setAttribute("version", "1.1");
            rootElement.setAttribute("xmlns", "http://www.w3.org/2000/svg");
            rootElement.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
            this.svgDocument.appendChild(rootElement);
            Element elementG = this.svgDocument.createElement("g");
            double translateX = -diagFrame.getX();
            double translateY = -diagFrame.getY();
            elementG.setAttribute("transform", "translate(" + (translateX + BORDER_X) + "," + (translateY + BORDER_Y) + ") scale(" + SCALE_X + "," + SCALE_Y + ")");
            rootElement.appendChild(elementG);
            this.createCGDiagram(diagFrame.getWidth(), diagFrame.getHeight());
            int index = 0;
            while (index < diagram.getGroups().size()) {
                Group group = diagram.getGroups().get(index);
                this.createGroup(group, elementG);
                ++index;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        if (this.gc != null) {
            this.gc.dispose();
        }
    }

    private void applyStyle(DElement element, Primitive primitive, Element xmlElement, Color bgColor) {
        Color fgColor = null;
        if (primitive != null) {
            fgColor = primitive.getForeColor();
        }
        if (fgColor == null) {
            fgColor = element instanceof Edge ? bgColor : Color.BLACK;
        }
        int lineWidth = -1;
        if (element instanceof Edge) {
            lineWidth = (int)((Edge)element).getLineWidth();
        }
        if (lineWidth < 0) {
            lineWidth = 1;
        }
        Object style = "";
        style = (String)style + "stroke:rgb(" + fgColor.getR() + "," + fgColor.getG() + "," + fgColor.getB() + ");";
        style = bgColor != null ? (String)style + "fill:rgb(" + bgColor.getR() + "," + bgColor.getG() + "," + bgColor.getB() + ");" : (String)style + "fill:none;";
        style = (String)style + "stroke-width:" + lineWidth;
        xmlElement.setAttribute("style", (String)style);
    }

    private void applyStyle(DElement element, Primitive primitive, Element xmlElement) {
        Color fgColor = null;
        if (primitive != null) {
            fgColor = primitive.getForeColor();
        }
        if (fgColor == null) {
            fgColor = element.getForeColor();
        }
        if (fgColor == null) {
            fgColor = Color.BLACK;
        }
        Color bgColor = null;
        if (element instanceof Edge) {
            bgColor = null;
        } else {
            if (primitive != null) {
                bgColor = primitive.getBackColor();
            }
            if (bgColor == null) {
                bgColor = element.getBackColor();
            }
        }
        int lineWidth = -1;
        if (lineWidth < 0) {
            lineWidth = 1;
        }
        Object style = "";
        style = fgColor != null ? (String)style + "stroke:rgb(" + fgColor.getR() + "," + fgColor.getG() + "," + fgColor.getB() + ");" : (String)style + "stroke:none;";
        style = bgColor != null ? (String)style + "fill:rgb(" + bgColor.getR() + "," + bgColor.getG() + "," + bgColor.getB() + ");" : (String)style + "fill:none;";
        style = (String)style + "stroke-width:" + lineWidth;
        xmlElement.setAttribute("style", (String)style);
    }

    private void applyEdgeStyle(Edge element, Primitive primitive, Element xmlElement) {
        Color fgColor = null;
        if (primitive != null) {
            fgColor = primitive.getForeColor();
        }
        if (fgColor == null) {
            fgColor = element.getForeColor();
        }
        if (fgColor == null) {
            fgColor = Color.BLACK;
        }
        Color bgColor = null;
        if (element instanceof Edge) {
            bgColor = null;
        } else {
            if (primitive != null) {
                bgColor = primitive.getBackColor();
            }
            if (bgColor == null) {
                bgColor = element.getBackColor();
            }
        }
        int lineWidth = -1;
        if (lineWidth < 0) {
            lineWidth = 1;
        }
        Object style = "";
        style = fgColor != null ? (String)style + "stroke:rgb(" + fgColor.getR() + "," + fgColor.getG() + "," + fgColor.getB() + ");" : (String)style + "stroke:none;";
        style = bgColor != null ? (String)style + "fill:rgb(" + bgColor.getR() + "," + bgColor.getG() + "," + bgColor.getB() + ");" : (String)style + "fill:none;";
        style = (String)style + "stroke-width:" + lineWidth;
        if (element.getLineStyle() == Edge.LineStyle.DASH) {
            style = (String)style + ";stroke-dasharray:" + String.valueOf(element.getDashLineLength()) + "," + String.valueOf(element.getDashLength());
        }
        xmlElement.setAttribute("style", (String)style);
    }

    private void createEdge(Edge graphEdge, Element parent) {
        Element container = parent;
        Element element = this.svgDocument.createElement("polyline");
        DiagramEdgeRenderHelper edgeHelper = new DiagramEdgeRenderHelper();
        String points = SVGDiagramPrinter.genPolygon(edgeHelper.getPoints(graphEdge));
        element.setAttribute("points", points);
        List<Point> pointsD = graphEdge.getPoints();
        if (graphEdge.getArrowType() == Edge.ArrowType.ARROW_TARGET && pointsD != null && pointsD.size() >= 2) {
            double deltaX = pointsD.get(pointsD.size() - 1).getX() - pointsD.get(pointsD.size() - 2).getX();
            double deltaY = pointsD.get(pointsD.size() - 1).getY() - pointsD.get(pointsD.size() - 2).getY();
            double angle = Math.atan2(deltaX, -deltaY);
            double arrowX = pointsD.get(pointsD.size() - 1).getX();
            double arrowY = pointsD.get(pointsD.size() - 1).getY();
            DiagramArrowRenderHelper arrowHelper = new DiagramArrowRenderHelper();
            List<Point> arrowPoints = arrowHelper.getArrowPoints(graphEdge);
            Element arrow = this.svgDocument.createElement("polyline");
            arrow.setAttribute("points", SVGDiagramPrinter.genPolygon(arrowPoints));
            arrow.setAttribute("transform", "translate(" + arrowX + " " + arrowY + ") rotate(" + angle * 180.0 / Math.PI + " 0 0)");
            this.applyStyle(graphEdge, null, arrow, graphEdge.getForeColor());
            container.appendChild(arrow);
        }
        this.applyEdgeStyle(graphEdge, null, element);
        container.appendChild(element);
    }

    private void createGroup(Group group, Element container) {
        int index = 0;
        while (index < group.getEdges().size()) {
            Edge graphEdge = group.getEdges().get(index);
            this.createEdge(graphEdge, container);
            ++index;
        }
        index = 0;
        while (index < group.getNodes().size()) {
            Node graphNode = group.getNodes().get(index);
            this.processGraphicalNode(graphNode, container);
            ++index;
        }
        index = 0;
        while (index < group.getTexts().size()) {
            Text graphText = group.getTexts().get(index);
            this.createText(graphText, container);
            ++index;
        }
        index = 0;
        while (index < group.getGroups().size()) {
            Group subGroup = group.getGroups().get(index);
            this.createGroup(subGroup, container);
            ++index;
        }
    }

    private void processGraphicalNode(Node graphNode, Element parent) {
        ArrayList<Primitive> primitives = new ArrayList<Primitive>();
        Symbol symbol = graphNode.getSymbol();
        Frame frame = graphNode.getFrame();
        if (symbol != null) {
            primitives.addAll(symbol.getPrimitives());
        }
        for (Primitive p : primitives) {
            Element pElement = null;
            if (p instanceof PArc) {
                pElement = this.paintArc((PArc)p, parent);
            } else if (p instanceof PCircle) {
                pElement = this.paintEllipse((PCircle)p, parent, frame);
            } else if (p instanceof PLine) {
                pElement = this.paintLine((PLine)p, parent);
            } else if (p instanceof PPolyline) {
                pElement = this.paintPolyline((PPolyline)p, parent, frame);
            } else if (!(p instanceof PImage) && p instanceof PRect && graphNode.getBackColor() != null & graphNode.getForeColor() != null) {
                pElement = this.paintRect((PRect)p, parent, frame);
            }
            if (pElement == null) continue;
            this.applyStyle(graphNode, p, pElement);
        }
    }

    public void createText2(Element container, String text, Text graphText, int lineNr, String style) {
        int pos = this.getMaxLinePos2(text, graphText);
        String textToPrint = text.substring(0, pos).trim();
        int y = (int)(graphText.getY() + (double)lineNr * graphText.getTextSize() + (double)(lineNr - 1) * graphText.getLineSpacing());
        int offsetX = 0;
        int offsetY = 0;
        org.eclipse.swt.graphics.Point test = null;
        if (graphText.getTextAlign() == Text.TextAlign.CENTER) {
            test = this.gc.stringExtent(textToPrint);
            offsetX = (int)((graphText.getWidth() - (double)test.x) / 2.0);
        }
        Element element = this.svgDocument.createElement("text");
        element.setAttribute("x", new Double(graphText.getX() + (double)offsetX).toString());
        element.setAttribute("y", "" + y + offsetY);
        element.setAttribute("style", style);
        if (graphText.getTextAlign().toString() == "CENTER") {
            element.setAttribute("x", new Double(graphText.getX() + (double)offsetX + graphText.getWidth() / 2.0).toString());
            element.setAttribute("text-anchor", "middle");
        }
        element.setTextContent(textToPrint);
        container.appendChild(element);
        if (pos < text.length()) {
            String restText = text.substring(pos, text.length()).trim();
            this.createText2(container, restText, graphText, lineNr + 1, style);
        }
    }

    public int getMaxLinePos(String text, Text graphText) {
        int pos;
        int maxLineLength = (int)(graphText.getWidth() / (0.4 * graphText.getTextSize()));
        if (graphText.getWidth() == 0.0) {
            maxLineLength = text.length();
        }
        if (text.length() <= maxLineLength) {
            pos = text.length();
        } else {
            pos = maxLineLength;
            while (pos >= 0 && text.charAt(pos) != ' ') {
                --pos;
            }
            if (pos == -1) {
                pos = maxLineLength;
            }
        }
        return pos;
    }

    public int getMaxLinePos2(String text, Text graphText) {
        org.eclipse.swt.graphics.Point size = this.gc.stringExtent(text);
        int pos = text.length();
        if ((double)size.x > graphText.getWidth()) {
            String testText;
            int lastPos = -1;
            pos = 0;
            while (pos < text.length()) {
                if (text.charAt(pos) == ' ') {
                    testText = text.substring(0, pos);
                    org.eclipse.swt.graphics.Point sizeTest = this.gc.stringExtent(testText);
                    if ((double)sizeTest.x > graphText.getWidth()) break;
                    lastPos = pos;
                }
                ++pos;
            }
            if (lastPos == -1) {
                pos = 0;
                while (pos < text.length()) {
                    testText = text.substring(0, pos);
                    org.eclipse.swt.graphics.Point testSize = this.gc.stringExtent(testText);
                    if ((double)testSize.x > graphText.getWidth()) break;
                    lastPos = pos++;
                }
            }
            pos = lastPos;
        }
        if (pos <= 0) {
            pos = text.length();
        }
        return pos;
    }

    private void createText(Element container, String text, Text graphText, int lineNr, String style) {
        int pos = this.getMaxLinePos2(text, graphText);
        org.eclipse.swt.graphics.Point size = this.gc.stringExtent(text);
        String line = text.substring(0, pos).trim();
        int y = (int)(graphText.getY() + graphText.getTextSize() + (double)lineNr * ((double)size.y + graphText.getLineSpacing()));
        Element element = this.svgDocument.createElement("text");
        element.setAttribute("x", new Double(graphText.getX()).toString());
        element.setAttribute("y", "" + y);
        element.setAttribute("style", style);
        if (graphText.getTextAlign().toString() == "CENTER") {
            element.setAttribute("x", new Double(graphText.getX() + graphText.getWidth() / 2.0).toString());
            element.setAttribute("text-anchor", "middle");
            element.setAttribute("dominant-baseline", "middle");
        }
        element.setTextContent(line);
        container.appendChild(element);
        if (pos < text.length()) {
            this.createText(container, text.substring(pos, text.length()).trim(), graphText, lineNr + 1, style);
        }
    }

    private void createText(Text graphText, Element container) {
        DiagramGCUtil.applyFont(this.gc, graphText, this.display);
        Color textColor = graphText.getForeColor();
        Object colorString = textColor != null ? "fill:rgb(" + textColor.getR() + "," + textColor.getG() + "," + textColor.getB() + ")" : "fill:rgb(0,0,0)";
        String alignment = "";
        String dominant = "";
        if (graphText.getTextAlign() == Text.TextAlign.CENTER) {
            alignment = ";alignment-baseline:auto";
            dominant = ";dominant-baseline:auto";
        }
        String style = "stroke-width:1;font-family:Arial Narrow;font-size:" + graphText.getTextSize() + "px;" + (String)colorString + alignment + dominant;
        if (graphText.getFontStyle() == Text.FontStyle.BOLD) {
            style = style + ";font-weight:bold";
        }
        this.createText(container, graphText.getText(), graphText, 0, style);
    }

    private Element paintArc(PArc arc, Element container) {
        Element element = this.svgDocument.createElement("path");
        container.appendChild(element);
        return element;
    }

    private Element paintEllipse(PCircle ellipse, Element container, Frame ellipseFrame) {
        Element element = this.svgDocument.createElement("ellipse");
        element.setAttribute("cx", String.valueOf(ellipseFrame.getX() + ellipse.getX() * ellipseFrame.getWidth()));
        element.setAttribute("cy", String.valueOf(ellipseFrame.getY() + ellipse.getY() * ellipseFrame.getHeight()));
        element.setAttribute("rx", "" + ellipseFrame.getWidth() * ellipse.getR1());
        element.setAttribute("ry", "" + ellipseFrame.getHeight() * ellipse.getR2());
        container.appendChild(element);
        return element;
    }

    private Element paintLine(PLine line, Element container) {
        Element element = this.svgDocument.createElement("line");
        element.setAttribute("x1", new Double(line.getX1()).toString());
        element.setAttribute("y1", new Double(line.getY1()).toString());
        element.setAttribute("x2", new Double(line.getX2()).toString());
        element.setAttribute("y2", new Double(line.getY2()).toString());
        container.appendChild(element);
        return element;
    }

    private Element paintPolyline(PPolyline polygon, Element container, Frame polygonFrame) {
        Element element = this.svgDocument.createElement("polygon");
        double[] pointsX = (double[])polygon.getXArray().clone();
        double[] pointsY = (double[])polygon.getYArray().clone();
        int i = 0;
        while (i < pointsX.length) {
            pointsX[i] = polygonFrame.getX() + pointsX[i] * polygonFrame.getWidth();
            pointsY[i] = polygonFrame.getY() + pointsY[i] * polygonFrame.getHeight();
            ++i;
        }
        if (pointsX == null || pointsY == null || pointsX.length != pointsY.length) {
            return null;
        }
        element.setAttribute("points", SVGDiagramPrinter.genPolygon(pointsX, pointsY));
        container.appendChild(element);
        return element;
    }

    private Element paintRect(PRect rect, Element parent, Frame rectFrame) {
        Element element = this.svgDocument.createElement("rect");
        element.setAttribute("x", new Double(rectFrame.getX() + rect.getX() * rectFrame.getWidth()).toString());
        element.setAttribute("y", new Double(rectFrame.getY() + rect.getY() * rectFrame.getHeight()).toString());
        element.setAttribute("width", new Double(rectFrame.getWidth() * rect.getWidth()).toString());
        element.setAttribute("height", new Double(rectFrame.getHeight() * rect.getHeight()).toString());
        parent.appendChild(element);
        return element;
    }

    public void printSvg(OutputStream out) {
        try {
            DOMSource source = new DOMSource(this.svgDocument);
            StreamResult result = null;
            result = out == null ? new StreamResult(System.out) : new StreamResult(out);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("omit-xml-declaration", "yes");
            xformer.setOutputProperty("indent", "yes");
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
        }
        catch (TransformerException transformerException) {}
    }

    private static String genPolygon(List<Point> p) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < p.size()) {
            buf.append(p.get(i).getX());
            buf.append(",");
            buf.append(p.get(i).getY());
            buf.append(" ");
            ++i;
        }
        return buf.toString().trim();
    }

    public static String genPolygon(double[] x, double[] y) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < x.length) {
            buf.append(x[i]);
            buf.append(",");
            buf.append(y[i]);
            buf.append(" ");
            ++i;
        }
        return buf.toString().trim();
    }
}

