/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.iml;

import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.ImfReference;
import net.edgemind.ibee.core.iml.modules.base.ILockable;
import net.edgemind.ibee.core.util.ImfNameGetter;

public class LockedElementException
extends IbeeException {
    private static final long serialVersionUID = 1L;
    private IElement protectedElement;

    public LockedElementException(IElement protectedElement) {
        this.protectedElement = protectedElement;
    }

    @Override
    public String getMessage() {
        IElement resolvedElement;
        IElement protectedElement = this.getProtectedElement();
        IElement lockedElement = this.getLockedElement(protectedElement);
        String lockedElementName = "???";
        String lockedElementType = "???";
        if (lockedElement != null) {
            lockedElementType = lockedElement.giGetElementType().getDisplayName();
            ImfNameGetter nameGetter = new ImfNameGetter();
            lockedElementName = nameGetter.getName(lockedElement);
        }
        if (lockedElement instanceof ImfReference && (resolvedElement = ((ImfReference)lockedElement).resolve()) != null) {
            lockedElement = resolvedElement;
        }
        return String.format("%s '%s' is locked.", lockedElementType, lockedElementName);
    }

    public IElement getProtectedElement() {
        return this.protectedElement;
    }

    public IElement getLockedElement(IElement element) {
        IElement lockedElement;
        IElement lockedElement2;
        ImfReference reference;
        IElement resolvedElement;
        if (element instanceof ILockable && ((ILockable)element).getLocked().booleanValue()) {
            return element;
        }
        if (element.giGetResource() != null && element instanceof ImfReference && (resolvedElement = (reference = (ImfReference)element).resolve()) != null && (lockedElement2 = this.getLockedElement(resolvedElement)) != null) {
            return lockedElement2;
        }
        IElement parent = element.giGetParent();
        if (parent != null && (lockedElement = this.getLockedElement(parent)) != null) {
            return lockedElement;
        }
        return null;
    }
}

