/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.iml.domain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.edgemind.ibee.core.iml.domain.IDomain;
import net.edgemind.ibee.core.iml.domain.IDomainCompatibleChecker;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.domain.VersionComparator;
import net.edgemind.ibee.core.iml.domain.impl.ElementTypeImpl;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.IProxy;
import net.edgemind.ibee.core.iml.model.impl.DefaultProxy;
import net.edgemind.ibee.core.iml.model.impl.ElementImpl;
import net.edgemind.ibee.core.resource.IbeeResource;

public abstract class Domain
implements IDomain {
    private String name = "";
    private String version;
    private transient List<IElementType<?>> types = new ArrayList();
    private transient Map<String, IElementType<?>> typesMap;
    private List<IDomain> inheritedDomains = new ArrayList<IDomain>();
    private Function<IbeeResource, IProxy> proxyCreator;
    private IDomainCompatibleChecker compatiblechecker;
    private Map<Class<?>, Object> adapters = new HashMap();

    public Domain() {
        this.init();
    }

    public Domain(String name) {
        this.name = name;
        this.init();
    }

    protected final void finalizeInit() {
        for (IElementType<?> type : this.getTypesWithoutInherited()) {
            ((ElementTypeImpl)type).init();
        }
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<IElementType<?>> getTypesWithoutInherited() {
        return new ArrayList(this.types);
    }

    @Override
    public List<IElementType<?>> getTypes() {
        ArrayList types = new ArrayList();
        types.addAll(this.getTypesWithoutInherited());
        for (IDomain inheritedDomain : this.inheritedDomains) {
            types.addAll(inheritedDomain.getTypes());
        }
        return types;
    }

    protected void add(IElementType<?> type) {
        this.types.add(type);
    }

    @Override
    public IElementType<?> getType(String name) {
        IElementType<?> type2;
        if (this.typesMap == null) {
            this.typesMap = new HashMap();
            for (IElementType<?> type2 : this.types) {
                this.typesMap.put(type2.getName().toLowerCase(), type2);
            }
        }
        if ((type2 = this.typesMap.get(name.toLowerCase())) != null) {
            return type2;
        }
        for (IDomain inheritedDomain : this.inheritedDomains) {
            type2 = inheritedDomain.getType(name);
            if (type2 == null) continue;
            return type2;
        }
        return null;
    }

    @Override
    public <T extends IElement> T create(IElementType<T> type) {
        ElementImpl element = new ElementImpl(type);
        return (T)element;
    }

    @Override
    public int getTypeIndex(IElementType<?> type) {
        int index = 0;
        while (index < this.types.size()) {
            if (this.types.get(index).equals(type)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IDomain)) {
            return false;
        }
        IDomain domain = (IDomain)object;
        return domain.getName().equals(this.getName());
    }

    @Override
    public IDomain get() {
        return this;
    }

    public void setProxyCreator(Function<IbeeResource, IProxy> proxyCreator) {
        this.proxyCreator = proxyCreator;
    }

    @Override
    public IProxy createProxy(IbeeResource resource) {
        IProxy proxy = null;
        if (this.proxyCreator != null) {
            proxy = this.proxyCreator.apply(resource);
        }
        if (proxy == null) {
            proxy = new DefaultProxy();
        }
        return proxy;
    }

    public void addInheritedDomain(IDomain domain) {
        this.inheritedDomains.add(domain);
    }

    @Override
    public List<IDomain> getInheritedDomains() {
        return this.inheritedDomains;
    }

    @Override
    public boolean isCompatible(String modelVersion) {
        if (this.compatiblechecker != null) {
            return this.compatiblechecker.isCompatible(this, modelVersion);
        }
        VersionComparator versionComparator = new VersionComparator();
        return versionComparator.isBackwardCompatible(this.getVersion(), modelVersion);
    }

    public IDomainCompatibleChecker getCompatiblechecker() {
        return this.compatiblechecker;
    }

    public void setCompatibleChecker(IDomainCompatibleChecker compatiblechecker) {
        this.compatiblechecker = compatiblechecker;
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        return (T)this.adapters.get(clazz);
    }

    @Override
    public <T> void setAdapter(Class<T> clazz, T adapter) {
        this.adapters.put(clazz, adapter);
    }

    @Override
    public <T> T removeAdapter(Class<T> clazz) {
        return (T)this.adapters.remove(clazz);
    }
}

