/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.iml.domain.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IBasicReferenceType;
import net.edgemind.ibee.core.iml.domain.IDomain;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.domain.IFeature;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.domain.IType;
import net.edgemind.ibee.core.iml.domain.ImfComponentType;
import net.edgemind.ibee.core.iml.domain.ImfModelType;
import net.edgemind.ibee.core.iml.domain.ImfReferenceType;
import net.edgemind.ibee.core.iml.domain.impl.AttributeFeatureImpl;
import net.edgemind.ibee.core.iml.domain.impl.DisplayNameCreator;
import net.edgemind.ibee.core.iml.domain.impl.ElementFeatureImpl;
import net.edgemind.ibee.core.iml.domain.impl.ImfBasicReferenceTypeImpl;
import net.edgemind.ibee.core.iml.domain.impl.ImfComponentTypeImpl;
import net.edgemind.ibee.core.iml.domain.impl.ImfModelTypeImpl;
import net.edgemind.ibee.core.iml.domain.impl.ImfReferenceTypeImpl;
import net.edgemind.ibee.core.iml.domain.impl.ListFeatureImpl;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.ImfComponent;
import net.edgemind.ibee.core.iml.model.ImfIdComponent;
import net.edgemind.ibee.core.iml.model.ImfModel;
import net.edgemind.ibee.core.iml.model.ImfNamedElement;
import net.edgemind.ibee.core.iml.model.ImfReference;
import net.edgemind.ibee.core.iml.model.impl.ElementImpl;

public class ElementTypeImpl<T extends IElement>
extends ElementImpl
implements IElementType<T> {
    private static final long serialVersionUID = 1L;
    private Supplier<T> creator;
    private transient List<IListFeature<IElement>> listFeaturesLocal = new ArrayList<IListFeature<IElement>>();
    private transient List<IAttributeFeature> attributeFeaturesLocal = new ArrayList<IAttributeFeature>();
    private transient List<IElementFeature<IElement>> elementFeaturesLocal = new ArrayList<IElementFeature<IElement>>();
    private transient List<IListFeature<IElement>> listFeatures;
    private transient List<IAttributeFeature> attributeFeatures;
    private transient List<IElementFeature<IElement>> elementFeatures;
    private Map<IAttributeFeature, Integer> attributeFeatureIndexMap;
    private Map<IElementFeature<IElement>, Integer> elementFeatureIndexMap;
    private Map<IListFeature<IElement>, Integer> listFeatureIndexMap;
    private Map<String, IListFeature<IElement>> listFeaturesMap;
    private Map<String, IAttributeFeature> attributeFeaturesMap;
    private Map<String, IElementFeature<IElement>> elementFeaturesMap;
    private List<IFeature> keyFeatures = null;
    private List<IElementType<IElement>> inherited = new ArrayList<IElementType<IElement>>();
    private String name;
    private String displayName;
    private String description;
    private boolean isAbstract;
    private IDomain domain;
    private boolean isGlobal = false;
    private Map<String, String> meta = new HashMap<String, String>();
    private boolean initialized = false;

    public ElementTypeImpl() {
    }

    public ElementTypeImpl(IDomain domain) {
        this.domain = domain;
    }

    public synchronized void init() {
        if (this.initialized) {
            return;
        }
        for (IElementType<IElement> inherited : this.inherited) {
            ((ElementTypeImpl)inherited).init();
        }
        this.initAttributeFeatures();
        this.initAttributeFeatureMap();
        this.initAttributeFeatureIndexMap();
        this.initElementFeatures();
        this.initElementFeatureMap();
        this.initElementFeatureIndexMap();
        this.initListFeatures();
        this.initListFeatureMap();
        this.initListFeatureIndexMap();
        this.initKeyFeatures();
        this.initialized = true;
    }

    private void initAttributeFeatures() {
        HashSet<IAttributeFeature> set = new HashSet<IAttributeFeature>();
        set.addAll(this.attributeFeaturesLocal);
        for (IElementType<IElement> inheritedType : this.inherited) {
            set.addAll(inheritedType.getAttributeFeatures());
        }
        this.attributeFeatures = new ArrayList<IAttributeFeature>(set);
    }

    private void initAttributeFeatureMap() {
        this.attributeFeaturesMap = new HashMap<String, IAttributeFeature>();
        for (IAttributeFeature next : this.attributeFeatures) {
            this.attributeFeaturesMap.put(next.getName().toLowerCase(), next);
        }
    }

    private void initAttributeFeatureIndexMap() {
        this.attributeFeatureIndexMap = new HashMap<IAttributeFeature, Integer>();
        int index = 0;
        for (IAttributeFeature next : this.getAttributeFeatures()) {
            this.attributeFeatureIndexMap.put(next, index++);
        }
    }

    private void initElementFeatures() {
        HashSet<IElementFeature<IElement>> set = new HashSet<IElementFeature<IElement>>();
        set.addAll(this.elementFeaturesLocal);
        for (IElementType<IElement> inheritedType : this.inherited) {
            set.addAll(inheritedType.getElementFeatures());
        }
        this.elementFeatures = new ArrayList<IElementFeature<IElement>>(set);
    }

    private void initElementFeatureMap() {
        this.elementFeaturesMap = new HashMap<String, IElementFeature<IElement>>();
        for (IElementFeature<IElement> next : this.getElementFeatures()) {
            this.elementFeaturesMap.put(next.getName().toLowerCase(), next);
        }
    }

    private void initElementFeatureIndexMap() {
        this.elementFeatureIndexMap = new HashMap<IElementFeature<IElement>, Integer>();
        int index = 0;
        for (IElementFeature<IElement> next : this.getElementFeatures()) {
            this.elementFeatureIndexMap.put(next, index++);
        }
    }

    private void initListFeatures() {
        HashSet<IListFeature<IElement>> set = new HashSet<IListFeature<IElement>>();
        set.addAll(this.listFeaturesLocal);
        for (IElementType<IElement> inheritedType : this.inherited) {
            set.addAll(inheritedType.getListFeatures());
        }
        this.listFeatures = new ArrayList<IListFeature<IElement>>(set);
    }

    private void initListFeatureMap() {
        this.listFeaturesMap = new HashMap<String, IListFeature<IElement>>();
        for (IListFeature<IElement> next : this.getListFeatures()) {
            this.listFeaturesMap.put(next.getName().toLowerCase(), next);
        }
    }

    private void initListFeatureIndexMap() {
        this.listFeatureIndexMap = new HashMap<IListFeature<IElement>, Integer>();
        int index = 0;
        for (IListFeature<IElement> next : this.getListFeatures()) {
            this.listFeatureIndexMap.put(next, index++);
        }
    }

    private void initKeyFeatures() {
        this.keyFeatures = new ArrayList<IFeature>();
        this.getAllFeatures().stream().filter(feature -> feature.isKey()).forEach(feature -> {
            boolean bl = this.keyFeatures.add((IFeature)feature);
        });
    }

    public void setDomain(IDomain domain) {
        this.domain = domain;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = DisplayNameCreator.getDisplayName(this.name);
        }
        return this.displayName;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean value) {
        this.isAbstract = value;
    }

    public static <T extends IElement> IElementType<T> create(String name, IDomain domain) {
        ElementTypeImpl<T> type = new ElementTypeImpl<T>(domain);
        type.setName(name);
        return type;
    }

    public static <T extends IElement> IElementType<T> create(String name) {
        ElementTypeImpl<T> type = new ElementTypeImpl<T>();
        type.setName(name);
        return type;
    }

    public static <T extends ImfModel> ImfModelType<T> createModelType(String name) {
        ImfModelTypeImpl type = new ImfModelTypeImpl();
        type.setName(name);
        return type;
    }

    public static <T extends ImfReference> ImfReferenceType<T> createReferenceType(String name) {
        ImfReferenceTypeImpl type = new ImfReferenceTypeImpl();
        type.setName(name);
        return type;
    }

    public static <T extends ImfReference> IBasicReferenceType<T> createBasicReferenceType(String name) {
        return ElementTypeImpl.createBasicReferenceType(name, false);
    }

    public static <T extends ImfReference> IBasicReferenceType<T> createBasicReferenceType(String name, boolean idBased) {
        ImfBasicReferenceTypeImpl type = new ImfBasicReferenceTypeImpl(idBased);
        type.setName(name);
        return type;
    }

    public static <T extends ImfComponent> ImfComponentType<T> createComponentType(String name) {
        ImfComponentTypeImpl type = new ImfComponentTypeImpl();
        type.setName(name);
        return type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IAttributeFeature addAttribute(IAttributeFeature feature) {
        if (this.initialized) {
            throw new RuntimeException(String.format("Cannot add attribute feature '%s'. Domain '%s' is already initialized.", feature.getName(), this.getName()));
        }
        IAttributeFeature test = this.getAttributeFeatureLocal(this.name);
        if (test != null) {
            throw new RuntimeException("attribute feature '" + feature.getName() + "' exists already");
        }
        if (this.attributeFeaturesLocal == null) {
            this.attributeFeaturesLocal = new ArrayList<IAttributeFeature>();
        }
        this.attributeFeaturesLocal.add(feature);
        ((AttributeFeatureImpl)feature).setElementType(this);
        return feature;
    }

    public IAttributeFeature addAttribute(String name, IType<?> type) {
        return this.addAttribute(new AttributeFeatureImpl(name, type));
    }

    public <U extends IElement> IListFeature<U> addList(IListFeature<U> feature) {
        if (this.initialized) {
            throw new RuntimeException(String.format("Cannot add list feature '%s'. Domain '%s' is already initialized.", feature.getName(), this.getName()));
        }
        IListFeature<?> test = this.getListFeatureLocal(feature.getName());
        if (test != null) {
            throw new RuntimeException("list feature '" + feature.getName() + "' exists already");
        }
        if (this.listFeaturesLocal == null) {
            this.listFeaturesLocal = new ArrayList<IListFeature<IElement>>();
        }
        this.listFeaturesLocal.add(feature);
        ((ListFeatureImpl)feature).setElementType(this);
        return feature;
    }

    public <U extends IElement> IListFeature<U> addList(String name, IElementType<U> type) {
        return this.addList(new ListFeatureImpl<U>(name, type));
    }

    public <U extends IElement> IElementFeature<U> addElement(IElementFeature<U> feature) {
        if (this.initialized) {
            throw new RuntimeException(String.format("Cannot add element feature '%s'. Domain '%s' is already initialized.", feature.getName(), this.getName()));
        }
        IElementFeature<?> test = this.getElementFeatureLocal(feature.getName());
        if (test != null) {
            throw new RuntimeException("element feature '" + feature.getName() + "' exists already");
        }
        if (this.elementFeaturesLocal == null) {
            this.elementFeaturesLocal = new ArrayList<IElementFeature<IElement>>();
        }
        this.elementFeaturesLocal.add(feature);
        ((ElementFeatureImpl)feature).setElementType(this);
        return feature;
    }

    public <U extends IElement> IElementFeature<U> addElement(String name, IElementType<U> type) {
        return this.addElement(new ElementFeatureImpl<U>(name, type));
    }

    public List<IAttributeFeature> getAttributeFeaturesLocal() {
        return new ArrayList<IAttributeFeature>(this.attributeFeaturesLocal);
    }

    @Override
    public List<IAttributeFeature> getAttributeFeatures() {
        return this.attributeFeatures;
    }

    public List<IElementFeature<IElement>> getElementFeaturesLocal() {
        return this.elementFeaturesLocal;
    }

    @Override
    public List<IElementFeature<IElement>> getElementFeatures() {
        return this.elementFeatures;
    }

    public List<IListFeature<IElement>> getListFeaturesLocal() {
        return new ArrayList<IListFeature<IElement>>(this.listFeaturesLocal);
    }

    @Override
    public List<IListFeature<IElement>> getListFeatures() {
        return this.listFeatures;
    }

    public IAttributeFeature getAttributeFeatureLocal(String name) {
        if (this.attributeFeaturesLocal == null) {
            return null;
        }
        for (IAttributeFeature next : this.attributeFeaturesLocal) {
            if (!next.getName().equalsIgnoreCase(name)) continue;
            return next;
        }
        return null;
    }

    @Override
    public IAttributeFeature getAttributeFeature(String name) {
        this.init();
        return this.attributeFeaturesMap.get(name.toLowerCase());
    }

    @Override
    public int getAttributeFeatureIndex(String name) {
        return this.getAttributeFeatureIndex(this.getAttributeFeature(name));
    }

    @Override
    public int getAttributeFeatureIndex(IAttributeFeature attr) {
        if (this.attributeFeatureIndexMap.containsKey(attr)) {
            return this.attributeFeatureIndexMap.get(attr);
        }
        return -1;
    }

    public IListFeature<?> getListFeatureLocal(String name) {
        if (this.listFeaturesLocal == null) {
            return null;
        }
        for (IListFeature<IElement> next : this.listFeaturesLocal) {
            if (!next.getName().equalsIgnoreCase(name)) continue;
            return next;
        }
        return null;
    }

    @Override
    public IListFeature<IElement> getListFeature(String name) {
        return this.listFeaturesMap.get(name.toLowerCase());
    }

    @Override
    public int getListFeatureIndex(String name) {
        return this.getListFeatureIndex(this.getListFeature(name));
    }

    @Override
    public int getListFeatureIndex(IListFeature<?> listFeature) {
        if (this.listFeatureIndexMap.containsKey(listFeature)) {
            return this.listFeatureIndexMap.get(listFeature);
        }
        return -1;
    }

    @Override
    public int getListFeatureCount() {
        return this.getListFeatures().size();
    }

    @Override
    public int getElementFeatureCount() {
        return this.getElementFeatures().size();
    }

    @Override
    public int getAttributeFeatureCount() {
        return this.getAttributeFeatures().size();
    }

    public IElementFeature<?> getElementFeatureLocal(String name) {
        if (this.elementFeaturesLocal == null) {
            return null;
        }
        for (IElementFeature<IElement> next : this.elementFeaturesLocal) {
            if (!next.getName().equalsIgnoreCase(name)) continue;
            return next;
        }
        return null;
    }

    @Override
    public IElementFeature<IElement> getElementFeature(String name) {
        return this.elementFeaturesMap.get(name.toLowerCase());
    }

    @Override
    public int getElementFeatureIndex(String name) {
        return this.getElementFeatureIndex(this.getElementFeature(name));
    }

    @Override
    public int getElementFeatureIndex(IElementFeature<?> elementFeature) {
        if (this.elementFeatureIndexMap.containsKey(elementFeature)) {
            return this.elementFeatureIndexMap.get(elementFeature);
        }
        return -1;
    }

    @Override
    public IFeature getFeature(String name) {
        IFeature f = this.getAttributeFeature(name);
        if (f != null) {
            return f;
        }
        f = this.getListFeature(name);
        if (f != null) {
            return f;
        }
        f = this.getElementFeature(name);
        if (f != null) {
            return f;
        }
        return null;
    }

    @Override
    public List<IFeature> getAllFeatures() {
        ArrayList<IFeature> features = new ArrayList<IFeature>();
        features.addAll(this.getAttributeFeatures());
        features.addAll(this.getElementFeatures());
        features.addAll(this.getListFeatures());
        return features;
    }

    @Override
    public boolean equals(IElementType<?> type) {
        return this.getName().equalsIgnoreCase(type.getName());
    }

    @Override
    public IDomain getDomain() {
        return this.domain;
    }

    @Override
    public boolean hasAttributeFeature(String name) {
        for (IAttributeFeature test : this.getAttributeFeatures()) {
            if (!test.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasElementFeature(String name) {
        for (IElementFeature<IElement> test : this.getElementFeatures()) {
            if (!test.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasListFeature(String name) {
        for (IListFeature<IElement> test : this.getListFeatures()) {
            if (!test.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasAttributeFeature(IAttributeFeature feature) {
        for (IAttributeFeature test : this.getAttributeFeatures()) {
            if (!test.getName().equalsIgnoreCase(feature.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasElementFeature(IElementFeature<?> feature) {
        for (IElementFeature<IElement> test : this.getElementFeatures()) {
            if (!test.getName().equalsIgnoreCase(feature.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasListFeature(IListFeature<?> feature) {
        for (IListFeature<IElement> test : this.getListFeatures()) {
            if (!test.getName().equalsIgnoreCase(feature.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IElementType)) {
            return false;
        }
        IElementType elementType = (IElementType)object;
        if (!elementType.getName().equals(this.getName())) {
            return false;
        }
        if (this.getDomain() == null || elementType.getDomain() == null) {
            return false;
        }
        return this.getDomain().equals(elementType.getDomain());
    }

    @Override
    public boolean inherits(IElementType<?> type) {
        if (this.equals(type)) {
            return true;
        }
        for (IElementType<IElement> inherited : this.inherited) {
            if (!inherited.inherits(type)) continue;
            return true;
        }
        return false;
    }

    public void addInherited(IElementType<? extends IElement> type) {
        this.inherited.add(type);
    }

    public void setMeta(String key, String value) {
        this.meta.put(key, value);
    }

    @Override
    public Map<String, String> getMeta() {
        return this.meta;
    }

    @Override
    public boolean isGlobal() {
        return this.isGlobal;
    }

    public void setGlobal(boolean value) {
        this.isGlobal = value;
    }

    @Override
    public boolean isComponentType() {
        if (this instanceof ImfComponentType) {
            return true;
        }
        for (IElementType<IElement> type : this.inherited) {
            if (!type.isComponentType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isModelType() {
        return this instanceof ImfModelType;
    }

    @Override
    public boolean isReferenceType() {
        return this instanceof ImfReferenceType;
    }

    @Override
    public boolean isNamed() {
        return this.getAttributeFeatureIndex(ImfNamedElement.nameFeature) != -1;
    }

    @Override
    public boolean isIdBased() {
        return this.getAttributeFeatureIndex(ImfIdComponent.idFeature) != -1;
    }

    @Override
    public T createIntance() {
        if (this.creator == null) {
            throw new IbeeException(String.format("Cannot create instance of type %s. No creator provided", this.name));
        }
        return (T)((IElement)this.creator.get());
    }

    public Supplier<T> getCreator() {
        return this.creator;
    }

    public void setCreator(Supplier<T> creator) {
        this.creator = creator;
    }

    @Override
    public List<IFeature> getKeyFeatures() {
        if (this.keyFeatures == null) {
            return new ArrayList<IFeature>();
        }
        return new ArrayList<IFeature>(this.keyFeatures);
    }
}

