/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.iml.domain.impl;

import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.domain.impl.FeatureImpl;
import net.edgemind.ibee.core.iml.model.IElement;

public class ListFeatureImpl<T extends IElement>
extends FeatureImpl
implements IListFeature<T> {
    private List<IElementType<? extends T>> types = new ArrayList<IElementType<? extends T>>();
    private int min = 0;
    private int max = -1;
    private boolean isContainment = false;
    private boolean isOrdered = false;
    private boolean isContainer = false;
    private boolean isGlobal = false;
    private boolean isRoot = false;

    public ListFeatureImpl() {
    }

    public ListFeatureImpl(String name) {
        this.setName(name);
    }

    public ListFeatureImpl(String name, IElementType<T> type) {
        this.setName(name);
        this.types.add(type);
    }

    public ListFeatureImpl<T> addType(IElementType<? extends T> type) {
        this.types.add(type);
        return this;
    }

    @Override
    public List<IElementType<? extends T>> getTypes() {
        return this.types;
    }

    public IListFeature<T> setMin(int min) {
        this.min = min;
        return this;
    }

    public IListFeature<T> setMax(int max) {
        this.max = max;
        return this;
    }

    @Override
    public int getMin() {
        return this.min;
    }

    @Override
    public int getMax() {
        return this.max;
    }

    @Override
    public boolean isContainment() {
        return this.isContainment;
    }

    public ListFeatureImpl isContainment(boolean value) {
        this.isContainment = value;
        return this;
    }

    @Override
    public boolean isOrdered() {
        return this.isOrdered;
    }

    public void isOrdered(boolean value) {
        this.isOrdered = value;
    }

    @Override
    public boolean isGlobal() {
        return this.isGlobal;
    }

    public void isGlobal(boolean isGlobal) {
        this.isGlobal = isGlobal;
    }

    @Override
    public boolean isContainer() {
        return this.isContainer;
    }

    public void isContainer(boolean isContainer) {
        this.isContainer = isContainer;
    }

    @Override
    public boolean isReference() {
        return this.types.stream().allMatch(type -> type.isReferenceType());
    }

    public void isRoot(boolean value) {
        this.isRoot = value;
    }

    @Override
    public boolean containsModules() {
        return this.isRoot && this.isContainer;
    }
}

