/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.iml.domain.types;

import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.iml.domain.impl.TypeImpl;

public class DateType
extends TypeImpl<LocalDateTime> {
    public static DateType instance = new DateType();
    public static DateTimeFormatter dateFormat = new DateTimeFormatterBuilder().appendPattern("dd-MM-yyyy").optionalStart().appendPattern(" HH:mm:ss").optionalEnd().parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter();
    public static DateTimeFormatter oldDateFormat = DateTimeFormatter.ofPattern("dd-MM-yy HH:mm:ss");

    public DateType() {
        super("date");
    }

    @Override
    public boolean isTypeValue(String value) {
        return true;
    }

    @Override
    public LocalDateTime fromString(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            return LocalDateTime.parse(value, dateFormat);
        }
        catch (DateTimeException dateTimeException) {
            try {
                return LocalDateTime.parse(value, oldDateFormat);
            }
            catch (DateTimeException e2) {
                throw new IbeeException(e2);
            }
        }
    }

    @Override
    public String toString(LocalDateTime localDate) {
        if (localDate == null) {
            return "";
        }
        return dateFormat.format(localDate);
    }
}

