/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.iml.model.delegate;

import net.edgemind.ibee.core.context.IContext;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.IProxy;
import net.edgemind.ibee.core.iml.model.ImfReference;
import net.edgemind.ibee.core.iml.model.delegate.NSDelegate;
import net.edgemind.ibee.core.iml.model.impl.DefaultProxy;
import net.edgemind.ibee.core.resource.IbeeResource;

public class ReferenceDelegate {
    private ImfReference ref;

    public ReferenceDelegate(ImfReference ref) {
        this.ref = ref;
    }

    private NSDelegate nsImpl() {
        return new NSDelegate(this.ref);
    }

    public IElement resolve() {
        return this.resolve(null);
    }

    public IElement resolve(IContext context) {
        IbeeResource resource = this.ref.giGetResource();
        if (resource == null) {
            throw new IbeeException("Cannot resolve reference: Reference is not in a Resource.");
        }
        IProxy proxy = resource.getProxy();
        if (proxy == null) {
            proxy = new DefaultProxy();
        }
        if (context == null) {
            context = resource.getContext();
        }
        return proxy.resolve(this.ref, context);
    }

    public void setTarget(IElement target) {
        IbeeResource resource = this.ref.giGetResource();
        if (resource == null) {
            throw new IbeeException("Cannot resolve reference: Reference is not in a Resource.");
        }
        IProxy proxy = resource.getProxy();
        if (proxy == null) {
            proxy = new DefaultProxy();
        }
        proxy.setTarget(this.ref, target);
    }

    public String getNamespace() {
        return this.nsImpl().getNamespace();
    }

    public void setNamespace(String ns) {
        this.nsImpl().setNamespace(ns);
    }
}

