/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.iml.model.impl;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.edgemind.ibee.core.context.IContext;
import net.edgemind.ibee.core.gni.IGni;
import net.edgemind.ibee.core.gni.impl.ImfGniImpl;
import net.edgemind.ibee.core.iml.LockedElementException;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.domain.IEnumType;
import net.edgemind.ibee.core.iml.domain.IFeature;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.domain.IOrderedListFeature;
import net.edgemind.ibee.core.iml.domain.ImfComponentType;
import net.edgemind.ibee.core.iml.domain.impl.AttributeFeatureImpl;
import net.edgemind.ibee.core.iml.model.IContainer;
import net.edgemind.ibee.core.iml.model.IContent;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.IElementHandle;
import net.edgemind.ibee.core.iml.model.IElementRestricted;
import net.edgemind.ibee.core.iml.model.IListHandle;
import net.edgemind.ibee.core.iml.model.INamespace;
import net.edgemind.ibee.core.iml.model.IOrderedListHandle;
import net.edgemind.ibee.core.iml.model.ImfComponent;
import net.edgemind.ibee.core.iml.model.ImfIdComponent;
import net.edgemind.ibee.core.iml.model.ImfModel;
import net.edgemind.ibee.core.iml.model.ImfNamedElement;
import net.edgemind.ibee.core.iml.model.ImfReference;
import net.edgemind.ibee.core.iml.model.Variant;
import net.edgemind.ibee.core.iml.model.impl.ContainerImpl;
import net.edgemind.ibee.core.iml.model.impl.ElementHandleImpl;
import net.edgemind.ibee.core.iml.model.impl.ListHandleImpl;
import net.edgemind.ibee.core.iml.model.impl.OrderedListHandleImpl;
import net.edgemind.ibee.core.iml.modules.base.ILockable;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.core.resource.ContextUtil;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.impl.IbeeResourceImpl;
import net.edgemind.ibee.util.string.StringUtil;

public class AElementImpl
implements IElement,
Serializable,
IElementRestricted {
    private static final long serialVersionUID = 1L;
    private Object[] features;
    private IFeature parentFeature;
    private long elementId = -1L;
    private long parent;
    private long syncId = -1L;
    protected transient IbeeResource resource;
    private Map<String, Object> data = null;
    private static Charset charSet = Charset.forName("utf-8");

    static {
        ((AttributeFeatureImpl)ImfNamedElement.nameFeature).isKey(true);
        ((AttributeFeatureImpl)ImfNamedElement.nameFeature).setCaseInSensitive(true);
    }

    private void setElementInternal(IElementFeature<?> feature, long id) {
        int index = this.giGetElementType().getElementFeatureIndex(feature);
        int offset = this.giGetElementType().getAttributeFeatureCount();
        this.features[index += offset] = id;
    }

    private void setListInternal(IListFeature<? extends IElement> feature, Collection<Long> ids) {
        int index = this.giGetElementType().getListFeatureIndex(feature);
        int offset = this.giGetElementType().getAttributeFeatureCount() + this.giGetElementType().getElementFeatureCount();
        this.features[index += offset] = ids;
    }

    public synchronized IElementType<?> giGetElementType() {
        return null;
    }

    @Override
    public synchronized IbeeResource giGetResource() {
        return this.resource;
    }

    @Override
    public synchronized void giSetResource(IbeeResource resource) {
        this.resource = resource;
    }

    @Override
    public synchronized long giGetElementId() {
        return this.elementId;
    }

    @Override
    public synchronized void giSetId(long id) {
        this.elementId = id;
    }

    @Override
    public void giSetAttribute(String name, String value) {
        IAttributeFeature feature = this.giGetElementType().getAttributeFeature(name);
        if (feature == null) {
            LogUtil.log("Element '" + this.giGetElementType().getName() + "' has no attribute '" + name + "\"", LogLevel.WARNING);
            return;
        }
        this.giSetAttribute(feature, value);
    }

    @Override
    public void giSetAttribute(IAttributeFeature feature, String value) {
        this.giSetAttribute(feature, value, false);
    }

    @Override
    public void giSetAttributeRaw(String name, String value) {
        IAttributeFeature feature = this.giGetElementType().getAttributeFeature(name);
        if (feature == null) {
            LogUtil.log("Element '" + this.giGetElementType().getName() + "' has no attribute '" + name + "\"", LogLevel.WARNING);
            return;
        }
        this.giSetAttributeRaw(feature, value);
    }

    @Override
    public void giSetAttributeRaw(IAttributeFeature feature, String value) {
        this.giSetAttribute(feature, value, true);
    }

    private synchronized void giSetAttribute(IAttributeFeature feature, String value, boolean raw) {
        String old;
        int index = this.giGetElementType().getAttributeFeatureIndex(feature);
        if (index == -1) {
            LogUtil.log("Element '" + this.giGetElementType().getName() + "' has no attribute '" + feature.getName() + "\"", LogLevel.WARNING);
            return;
        }
        if (this.features == null) {
            this.initFeatureArray();
        }
        String string = old = this.features[index] != null ? (String)this.features[index] : null;
        if (this.isEqual(feature, old, value)) {
            return;
        }
        if (feature != ILockable.lockedFeature && this.isProtected(feature)) {
            throw new LockedElementException(this);
        }
        boolean intern = feature.getType() instanceof IEnumType;
        Object object = StringUtil.isEmpty((String)value) ? null : (this.features[index] = intern ? value.intern() : value);
        if (this.notifyFeatureChange(feature)) {
            this.giNotify(feature, old, value);
        }
    }

    @Override
    public boolean notifyFeatureChange(IFeature feature) {
        return this.notificationsEnabled() || feature.isKey() || feature == ImfNamedElement.nameFeature || feature == ImfIdComponent.idFeature;
    }

    private void initFeatureArray() {
        int size = this.giGetElementType().getAttributeFeatureCount() + this.giGetElementType().getElementFeatureCount() + this.giGetElementType().getListFeatureCount();
        this.features = new Object[size];
    }

    private boolean notificationsEnabled() {
        IbeeResourceImpl res = (IbeeResourceImpl)this.giGetResource();
        return res != null && res.notificationsEnabled();
    }

    @Override
    public boolean isProtected(IFeature feature) {
        ImfReference reference;
        IElement element;
        IbeeResource resource = this.giGetResource();
        if (resource != null && !resource.notificationsEnabled()) {
            return false;
        }
        if (this instanceof ILockable && ((ILockable)((Object)this)).getLocked().booleanValue()) {
            return true;
        }
        if (resource != null && this instanceof ImfReference && feature.isKey() && (element = (reference = (ImfReference)((Object)this)).resolve()) != null) {
            return element.isProtected(feature);
        }
        IElement parent = this.giGetParent();
        if (parent != null) {
            return parent.isProtected(feature);
        }
        return false;
    }

    private boolean isEqual(IAttributeFeature feature, String value1, String value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 == null) {
            value1 = "";
        }
        if (value2 == null) {
            value2 = "";
        }
        return value1.equals(value2);
    }

    @Override
    public synchronized String giGetAttribute(String attributeName) {
        IbeeResource resource = this.giGetResource();
        IContext context = null;
        if (resource != null) {
            context = resource.getContext();
        }
        return this.giGetAttribute(attributeName, context);
    }

    @Override
    public synchronized String giGetAttribute(String attributeName, IContext context) {
        IAttributeFeature feature = this.giGetElementType().getAttributeFeature(attributeName);
        if (feature == null) {
            return "";
        }
        return this.giGetAttribute(feature, context);
    }

    @Override
    public synchronized String giGetAttributeRaw(String name) {
        return this.giGetAttributeRaw(this.giGetElementType().getAttributeFeature(name));
    }

    @Override
    public synchronized String giGetAttributeRaw(IAttributeFeature feature) {
        return this.giGetAttribute(feature, null, true);
    }

    @Override
    public String giGetAttribute(IAttributeFeature feature, IContext context) {
        return this.giGetAttribute(feature, context, false);
    }

    private synchronized String giGetAttribute(IAttributeFeature feature, IContext context, boolean raw) {
        Variant variant;
        int index = this.giGetElementType().getAttributeFeatureIndex(feature);
        if (index == -1) {
            LogUtil.log("Element '" + this.giGetElementType().getName() + "' has no attribute '" + feature.getName() + "\"", LogLevel.WARNING);
            return "";
        }
        String value = null;
        if (context != null && !feature.getName().equals("name") && (variant = context.getValue(Variant.class)) != null) {
            String objectNameToMatch = "";
            if (this.giGetElementType().hasAttributeFeature("name")) {
                objectNameToMatch = this.giGetAttribute("name");
            }
            String attributeNameToMatch = ContextUtil.getPatternFromAttributeFeature(feature);
            value = variant.getAttributeValue(attributeNameToMatch, objectNameToMatch);
        }
        if (value == null && this.features != null) {
            String string = value = this.features[index] != null ? (String)this.features[index] : null;
        }
        if (!raw && StringUtil.isEmpty(value)) {
            value = feature.getDefaultValue();
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    @Override
    public synchronized String giGetAttribute(IAttributeFeature feature) {
        IbeeResource resource = this.giGetResource();
        IContext context = null;
        if (resource != null) {
            context = resource.getContext();
        }
        return this.giGetAttribute(feature, context);
    }

    public synchronized IListHandle<IElement> giGetList(String name) {
        return this.giGetList(name, true);
    }

    public synchronized IListHandle<IElement> giGetList(String name, boolean create) {
        IListFeature<IElement> feature = this.giGetElementType().getListFeature(name);
        if (feature == null) {
            LogUtil.log("Element '" + this.giGetElementType().getName() + "' has no list '" + name + "\"", LogLevel.WARNING);
            return null;
        }
        return this.giGetList(feature, create);
    }

    @Override
    public synchronized <T extends IElement> IListHandle<T> giGetList(IListFeature<T> feature) {
        return this.giGetList(feature, true);
    }

    public synchronized <T extends IElement> IListHandle<T> giGetList(IListFeature<T> feature, boolean create) {
        int offset;
        IListHandle<T> list;
        int index = this.giGetElementType().getListFeatureIndex(feature);
        if (index == -1) {
            LogUtil.log("Element '" + this.giGetElementType().getName() + "' has no list '" + feature.getName() + "\"", LogLevel.WARNING);
            return null;
        }
        if (this.features == null) {
            this.initFeatureArray();
        }
        if ((list = (IContainer<T>)this.features[index += (offset = this.giGetElementType().getAttributeFeatureCount() + this.giGetElementType().getElementFeatureCount())]) == null) {
            list = feature.isContainer() ? this.createContainer(feature, index) : (feature.isOrdered() ? new OrderedListHandleImpl<T>(this, feature) : new OrderedListHandleImpl<T>(this, feature));
            this.features[index] = list;
        }
        return list;
    }

    private <T extends ImfComponent> IContainer<T> createContainer(IListFeature<T> feature, int index) {
        return new ContainerImpl<T>(this, feature);
    }

    public synchronized IElementHandle<IElement> giGetElement(String name) {
        return this.giGetElement(name, true);
    }

    public synchronized IElementHandle<IElement> giGetElement(String name, boolean create) {
        IElementFeature<IElement> feature = this.giGetElementType().getElementFeature(name);
        if (feature == null) {
            LogUtil.log("Element '" + this.giGetElementType().getName() + "' has no element '" + name + "\"", LogLevel.WARNING);
            return null;
        }
        return this.giGetElement(feature, create);
    }

    @Override
    public synchronized <T extends IElement> IElementHandle<T> giGetElement(IElementFeature<T> feature) {
        return this.giGetElement(feature, true);
    }

    public synchronized <T extends IElement> IElementHandle<T> giGetElement(IElementFeature<T> feature, boolean create) {
        int offset;
        ElementHandleImpl<T> handle;
        int index = this.giGetElementType().getElementFeatureIndex(feature);
        if (index == -1) {
            LogUtil.log("Element '" + this.giGetElementType().getName() + "' has no element '" + feature.getName() + "\"", LogLevel.WARNING);
            return null;
        }
        if (this.features == null) {
            this.initFeatureArray();
        }
        if ((handle = (ElementHandleImpl<T>)this.features[index += (offset = this.giGetElementType().getAttributeFeatureCount())]) == null) {
            this.features[index] = handle = new ElementHandleImpl<T>(this, feature);
        }
        return handle;
    }

    @Override
    public void giNotify(IFeature feature, Object oldValue, Object newValue) {
        this.giUpdateSyncId();
        IbeeResource model = this.giGetResource();
        if (model == null) {
            return;
        }
        model.notify(this, feature, oldValue, newValue);
    }

    @Override
    public synchronized IElement giGetParent() {
        IbeeResource resource;
        if (this.parent != -1L && (resource = this.giGetResource()) != null) {
            return resource.getObject(this.parent);
        }
        return null;
    }

    public synchronized void giSetParentId(Long parentId, IFeature parentFeature) {
        if (parentId == null) {
            this.parent = -1L;
            this.parentFeature = null;
        } else {
            this.parent = parentId;
            this.parentFeature = parentFeature;
        }
    }

    @Override
    public synchronized void giSetParent(IElement parent, IFeature parentFeature) {
        if (parent == null) {
            this.parent = -1L;
            this.parentFeature = null;
        } else {
            this.giSetParentId(parent.giGetElementId(), parentFeature);
        }
    }

    @Override
    public synchronized void giClear() {
        this.features = null;
    }

    public synchronized void giAdoptContentFromOtherElement(IElement otherElement) {
        IContent otherList;
        if (!otherElement.giGetElementType().equals(this.giGetElementType())) {
            throw new RuntimeException("giAdoptContentFromOtherElement failed, elements are not of same type");
        }
        this.giClear();
        for (IAttributeFeature iAttributeFeature : this.giGetElementType().getAttributeFeatures()) {
            String otherValue = otherElement.giGetAttribute(iAttributeFeature, null);
            if (otherValue == null || otherValue.isEmpty()) continue;
            if (this.features == null) {
                this.initFeatureArray();
            }
            int index = this.giGetElementType().getAttributeFeatureIndex(iAttributeFeature);
            this.features[index] = otherValue.intern();
        }
        for (IListFeature iListFeature : this.giGetElementType().getListFeatures()) {
            otherList = (ListHandleImpl)otherElement.giGetList(iListFeature);
            ListHandleImpl thisList = (ListHandleImpl)this.giGetList(iListFeature);
            thisList.setAllElementsByIdInject(((ListHandleImpl)otherList).getAllElementIds(), true);
        }
        for (IElementFeature iElementFeature : this.giGetElementType().getElementFeatures()) {
            otherList = (ElementHandleImpl)otherElement.giGetElement(iElementFeature);
            ElementHandleImpl thisList = (ElementHandleImpl)this.giGetElement(iElementFeature);
            thisList.setElementByIdInject(((ElementHandleImpl)otherList).getElementId(), true);
        }
        this.syncId = otherElement.giGetSyncId();
        this.parent = ((AElementImpl)otherElement).giGetParentId();
    }

    public long giGetParentId() {
        return this.parent;
    }

    public synchronized void giUpdateSyncId() {
        IbeeResource resource = this.giGetResource();
        if (resource == null) {
            this.syncId = -1L;
            return;
        }
        this.giSetSyncId(resource.getVersion());
    }

    @Override
    public synchronized void giSetSyncId(long syncId) {
        this.syncId = syncId;
    }

    @Override
    public synchronized long giGetSyncId() {
        return this.syncId;
    }

    @Override
    public IElement clone() {
        Object clone = this.giGetElementType().getDomain().create(this.giGetElementType());
        for (IAttributeFeature iAttributeFeature : this.giGetElementType().getAttributeFeatures()) {
            clone.giSetAttribute(iAttributeFeature, this.giGetAttribute(iAttributeFeature));
        }
        for (IListFeature iListFeature : this.giGetElementType().getListFeatures()) {
            List<Long> ids = ((ListHandleImpl)this.giGetList(iListFeature)).getAllElementIds();
            ((ListHandleImpl)clone.giGetList(iListFeature)).setAllElementsByIdInject(ids, false);
        }
        for (IElementFeature iElementFeature : this.giGetElementType().getElementFeatures()) {
            Long id = ((ElementHandleImpl)this.giGetElement(iElementFeature)).getElementId();
            ((ElementHandleImpl)clone.giGetElement(iElementFeature)).setElementByIdInject(id, false);
        }
        ((AElementImpl)clone).giSetSyncId(this.syncId);
        ((AElementImpl)clone).giSetParentId(this.parent, this.parentFeature);
        return clone;
    }

    @Override
    public IElement cloneFull() {
        Object clone = this.giGetElementType().getDomain().create(this.giGetElementType());
        this.giGetResource().putObject((IElement)clone);
        for (IAttributeFeature iAttributeFeature : this.giGetElementType().getAttributeFeatures()) {
            if (iAttributeFeature == ImfIdComponent.idFeature) continue;
            clone.giSetAttribute(iAttributeFeature, this.giGetAttribute(iAttributeFeature));
        }
        for (IListFeature iListFeature : this.giGetElementType().getListFeatures()) {
            if (iListFeature.isContainment()) {
                for (IElement e : this.giGetList(iListFeature).getElements()) {
                    IElement clonedChild = e.cloneFull();
                    clone.giGetList(iListFeature).addElement(clonedChild);
                }
                continue;
            }
            List<Long> ids = ((ListHandleImpl)this.giGetList(iListFeature)).getAllElementIds();
            ((ListHandleImpl)clone.giGetList(iListFeature)).setAllElementsByIdInject(ids, false);
        }
        for (IElementFeature iElementFeature : this.giGetElementType().getElementFeatures()) {
            if (iElementFeature.isContainment()) {
                IElement e;
                e = ((ElementHandleImpl)this.giGetElement(iElementFeature)).getElement();
                if (e == null) continue;
                IElement clonedChild = e.cloneFull();
                clone.giGetElement(iElementFeature).setElement(clonedChild);
                continue;
            }
            Long id = ((ElementHandleImpl)this.giGetElement(iElementFeature)).getElementId();
            ((ElementHandleImpl)clone.giGetElement(iElementFeature)).setElementByIdInject(id, false);
        }
        return clone;
    }

    @Override
    public void clear() {
        for (IAttributeFeature iAttributeFeature : this.giGetElementType().getAttributeFeatures()) {
            this.giSetAttribute(iAttributeFeature, null);
        }
        for (IListFeature iListFeature : this.giGetElementType().getListFeatures()) {
            this.giGetList(iListFeature).clearElements();
        }
        for (IElementFeature iElementFeature : this.giGetElementType().getElementFeatures()) {
            this.giGetElement(iElementFeature).setElement(null);
        }
    }

    @Override
    public void remove() {
        IElement parent = this.giGetParent();
        if (parent != null) {
            if (this.parentFeature instanceof IElementFeature) {
                parent.giGetElement((IElementFeature)this.parentFeature).unset();
            } else if (this.parentFeature instanceof IListFeature) {
                parent.giGetList((IListFeature)this.parentFeature).remove(this);
            }
        }
        this.giSetParent(null, null);
    }

    @Override
    public boolean isRemoved() {
        if (this.isRoot()) {
            return false;
        }
        IElement parent = this.giGetParent();
        return parent == null || parent.isRemoved();
    }

    @Override
    public IFeature giGetFeatureOf(IElement contained) {
        if (contained.giGetParent() == this) {
            return contained.giGetParentFeature();
        }
        return null;
    }

    @Override
    public ImfModel getModel() {
        IElement parent = this.giGetParent();
        if (parent != null) {
            return parent.getModel();
        }
        return null;
    }

    @Override
    public boolean isGlobal() {
        if (this.giGetElementType().isGlobal()) {
            return true;
        }
        IElement parent = this.giGetParent();
        if (parent != null) {
            IFeature feature = parent.giGetFeatureOf(this);
            if (feature instanceof IListFeature) {
                return ((IListFeature)feature).isGlobal();
            }
            if (feature instanceof IElementFeature) {
                return ((IElementFeature)feature).isGlobal();
            }
        }
        return false;
    }

    @Override
    public <T extends ImfComponent> IContainer<? super T> getContainer(ImfComponentType<T> type) {
        for (IListFeature<IElement> iListFeature : this.giGetElementType().getListFeatures()) {
            IElementType<IElement> nextType;
            if (!iListFeature.isContainer() || iListFeature.getTypes().size() != 1 || !type.inherits(nextType = iListFeature.getTypes().get(0))) continue;
            return (IContainer)this.giGetList(iListFeature);
        }
        for (IElementFeature iElementFeature : this.giGetElementType().getElementFeatures()) {
            T group;
            IContainer<T> container;
            if (!iElementFeature.isAutoCreate() || (container = (group = this.giGetElement(iElementFeature).getElement()).getContainer(type)) == null) continue;
            return container;
        }
        return null;
    }

    @Override
    public boolean isComponent() {
        return this.giGetElementType().isComponentType();
    }

    @Override
    public ImfComponent getModule() {
        if (this.isModule()) {
            return (ImfComponent)((Object)this);
        }
        if (this.giGetParent() != null) {
            return this.giGetParent().getModule();
        }
        return null;
    }

    @Override
    public IGni<IElement, IElementType<? extends IElement>> gni() {
        return new ImfGniImpl(this.giGetResource());
    }

    @Override
    public boolean isReference() {
        return this.giGetElementType().isReferenceType();
    }

    @Override
    public boolean isNamed() {
        return this instanceof ImfNamedElement;
    }

    @Override
    public boolean isEmpty() {
        for (IAttributeFeature iAttributeFeature : this.giGetElementType().getAttributeFeatures()) {
            String rawValue = this.giGetAttributeRaw(iAttributeFeature);
            if (rawValue == null || rawValue.isEmpty()) continue;
            return false;
        }
        for (IElementFeature iElementFeature : this.giGetElementType().getElementFeatures()) {
            Object child;
            if (!iElementFeature.isContainment() || iElementFeature.isAutoCreate() && !this.giGetElement(iElementFeature).isSet() || (child = this.giGetElement(iElementFeature).getElement()) == null || child.isEmpty()) continue;
            return false;
        }
        for (IListFeature iListFeature : this.giGetElementType().getListFeatures()) {
            if (!iListFeature.isContainment()) continue;
            for (Object child : this.giGetList(iListFeature)) {
                if (child.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isModule() {
        return false;
    }

    @Override
    public boolean isRoot() {
        IbeeResource resource = this.giGetResource();
        if (resource == null) {
            return false;
        }
        return resource.getRoot() == this;
    }

    @Override
    public void giAddChild(IElement child) {
        IElementType<? extends IElement> childElementType = child.giGetElementType();
        Iterator<IListFeature<IElement>> iterator = this.giGetElementType().getListFeatures().iterator();
        while (iterator.hasNext()) {
            IListFeature<IElement> feature;
            IListFeature<IElement> listFeature = feature = iterator.next();
            if (!feature.getTypes().contains(childElementType)) continue;
            this.giGetList(listFeature).add(child);
            break;
        }
    }

    @Override
    public <T extends IElement> IOrderedListHandle<T> giGetList(IOrderedListFeature<T> feature) {
        return (IOrderedListHandle)this.giGetList((IListFeature<T>)feature);
    }

    @Override
    public IFeature giGetParentFeature() {
        return this.parentFeature;
    }

    public void giSetParentFeature(IFeature parentFeature) {
        this.parentFeature = parentFeature;
    }

    @Override
    public String resolveNamespace() {
        String ns;
        if (this instanceof INamespace && !(ns = ((INamespace)((Object)this)).getNamespace()).equals("")) {
            return ns;
        }
        IElement parent = this.giGetParent();
        if (parent != null) {
            return parent.resolveNamespace();
        }
        return "#";
    }

    public <T> T getData(Class<T> clazz) {
        return (T)this.getData(clazz.getName());
    }

    public <T> void setData(Class<T> clazz, T object) {
        this.setData(clazz.getName(), object);
    }

    @Override
    public Object getData(String key) {
        if (this.data == null) {
            return null;
        }
        return this.data.get(key);
    }

    @Override
    public void setData(String key, Object value) {
        if (value == null) {
            this.removeData(key);
        } else {
            if (this.data == null) {
                this.data = new HashMap<String, Object>();
            }
            this.data.put(key, value);
        }
    }

    @Override
    public void removeData(String key) {
        if (this.data == null) {
            return;
        }
        this.data.remove(key);
    }

    @Override
    public Collection<IElement> getChildren() {
        ArrayDeque<IElement> res = new ArrayDeque<IElement>();
        for (IListFeature<IElement> iListFeature : this.giGetElementType().getListFeatures()) {
            IListHandle<IElement> listHandle;
            if (!iListFeature.isContainment() || (listHandle = this.giGetList(iListFeature, false)) == null) continue;
            res.addAll(listHandle.getElements());
        }
        for (IElementFeature iElementFeature : this.giGetElementType().getElementFeatures()) {
            Object child;
            IElementHandle elHandle;
            if (!iElementFeature.isContainment() || (elHandle = this.giGetElement(iElementFeature, false)) == null || (child = elHandle.getElement(false)) == null) continue;
            res.add((IElement)child);
        }
        return res;
    }

    @Override
    public boolean isKeyed() {
        return this.isComponent() || this.isReference() || this.isGlobal();
    }
}

