/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.iml.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.edgemind.ibee.core.iml.LockedElementException;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.IElementRestricted;
import net.edgemind.ibee.core.iml.model.IListHandle;
import net.edgemind.ibee.core.iml.model.impl.AElementImpl;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.ResourceFactory;
import net.edgemind.ibee.core.resource.ResourceImporter;

public abstract class ListHandleImpl<T extends IElement>
implements IListHandle<T>,
Collection<T> {
    private static final long serialVersionUID = 1L;
    protected Collection<Long> ids;
    protected IElement parent;
    protected IListFeature<T> feature;
    private boolean autoResourceManagement = true;

    protected abstract Collection<Long> createList();

    public ListHandleImpl(IElement parent, IListFeature<T> feature) {
        this.parent = parent;
        this.feature = feature;
    }

    public synchronized IElement getParent() {
        return this.parent;
    }

    public synchronized Collection<Long> getIds() {
        if (this.ids == null) {
            return new ArrayList<Long>();
        }
        return this.ids;
    }

    public boolean isAutoResourceManagement() {
        return this.autoResourceManagement;
    }

    public void setAutoResourceManagement(boolean autoResourceManagement) {
        this.autoResourceManagement = autoResourceManagement;
    }

    @Override
    public synchronized void addElements(Collection<? extends T> elements) {
        if (elements == null) {
            return;
        }
        List<Long> oldValue = null;
        if (this.notifyFeatureChange()) {
            oldValue = this.getAllElementIds();
        }
        for (IElement element : elements) {
            this.addElementInternal(element, -1);
        }
        if (this.notifyFeatureChange()) {
            this.notify(oldValue, this.getAllElementIds());
        }
    }

    @Override
    public synchronized T addElement(T element) {
        return this.addElementByIndex(element, -1);
    }

    private synchronized void addElementInternal(IElement element, int index) {
        Long elementIdToAdd = element.giGetElementId();
        if (this.ids == null) {
            this.ids = this.createList();
        }
        if (this.feature.isContainment() && this.ids.contains(elementIdToAdd)) {
            return;
        }
        this.validateElementToAdd(element);
        this.addElementToResource(element);
        this.insertId(element.giGetElementId(), index);
        this.setParent(element);
    }

    private void notifySetParent(IElement element) {
        IbeeResource resource = this.parent.giGetResource();
        if (resource != null) {
            resource.notifySetParent(element);
        }
    }

    private void notifyUnsetParent(IElement element) {
        IbeeResource resource = this.parent.giGetResource();
        if (resource != null) {
            resource.notifyUnsetParent(element);
        }
    }

    protected synchronized T addElementByIndex(T element, int index) {
        List<Long> oldValue = null;
        boolean notify = this.notifyFeatureChange();
        if (notify) {
            oldValue = this.getAllElementIds();
        }
        this.addElementInternal((IElement)element, index);
        if (notify) {
            this.notify(oldValue, this.getAllElementIds());
        }
        return element;
    }

    protected void insertId(long id, int index) {
        if (this.ids == null) {
            this.initIds();
        }
        this.ids.add(id);
    }

    private void initIds() {
        this.ids = this.createList();
    }

    private synchronized void setParent(IElement element) {
        if (element == null) {
            return;
        }
        if (this.feature.isContainment()) {
            ((IElementRestricted)((Object)element)).giSetParent(this.parent, this.feature);
            this.notifySetParent(element);
        }
    }

    private synchronized void unsetParent(IElement element) {
        if (element == null) {
            return;
        }
        if (this.feature.isContainment()) {
            ((AElementImpl)element).giSetParent(null, null);
            this.notifyUnsetParent(element);
        }
    }

    @Override
    public synchronized void clearElements() {
        if (this.ids == null || this.ids.isEmpty()) {
            return;
        }
        if (this.parent.isProtected(this.feature)) {
            throw new LockedElementException(this.parent);
        }
        List<Long> oldValue = this.getAllElementIds();
        this.ids.clear();
        if (this.feature.isContainment()) {
            IbeeResource model = this.parent.giGetResource();
            for (Long oldId : oldValue) {
                IElement element = model.getObject(oldId);
                this.unsetParent(element);
            }
        }
        if (this.notifyFeatureChange()) {
            this.notify(oldValue, this.getAllElementIds());
        }
    }

    @Override
    public synchronized void removeElement(IElement element) {
        if (element == null || this.ids == null) {
            return;
        }
        if (this.parent.isProtected(this.feature)) {
            throw new LockedElementException(this.parent);
        }
        List<Long> oldValue = null;
        if (this.notifyFeatureChange()) {
            oldValue = this.getAllElementIds();
        }
        this.ids.removeIf(next -> next.longValue() == element.giGetElementId());
        this.unsetParent(element);
        if (this.notifyFeatureChange()) {
            this.notify(oldValue, this.getAllElementIds());
        }
    }

    public synchronized List<Long> getAllElementIds() {
        if (this.ids == null) {
            return new ArrayList<Long>();
        }
        return new ArrayList<Long>(this.ids);
    }

    @Override
    public synchronized List<T> getElements() {
        ArrayList<IElement> result = new ArrayList<IElement>();
        IbeeResource model = this.parent.giGetResource();
        if (model == null || this.ids == null) {
            return result;
        }
        if (this.ids != null) {
            for (long id : this.ids) {
                IElement element = model.getObject(id);
                if (element == null) continue;
                result.add(element);
            }
        }
        return result;
    }

    @Override
    public synchronized void setElements(Collection<? extends T> elements) {
        List<Long> oldValue = this.getAllElementIds();
        if (this.ids != null) {
            this.ids.clear();
        }
        if (elements != null) {
            for (IElement element : elements) {
                this.addElementInternal(element, -1);
            }
        }
        if (this.ids != null && this.feature.isContainment()) {
            IbeeResource model = this.parent.giGetResource();
            for (Long oldId : oldValue) {
                if (this.ids.contains(oldId)) continue;
                IElement element = model.getObject(oldId);
                this.unsetParent(element);
            }
        }
        if (this.notifyFeatureChange()) {
            this.notify(oldValue, this.getAllElementIds());
        }
    }

    public void setAllElementsByIdInject(List<Long> newIds, boolean notify) {
        this.setAllElementsByIdInject(newIds, notify, true);
    }

    public synchronized void setAllElementsByIdInject(List<Long> newIds, boolean notify, boolean updateParents) {
        IElement element;
        IbeeResource model;
        boolean requiresNotify = notify;
        List<Long> oldIds = null;
        if (requiresNotify) {
            oldIds = this.getAllElementIds();
        }
        if (updateParents && this.feature.isContainment() && (model = this.parent.giGetResource()) != null && this.ids != null) {
            for (Long l : this.ids) {
                element = model.getObject(l);
                this.unsetParent(element);
            }
        }
        if (this.ids != null) {
            this.ids.clear();
        }
        if (newIds != null) {
            for (Long newId : newIds) {
                if (this.ids == null) {
                    this.ids = this.createList();
                }
                if (this.getFeature().isContainment() && this.ids.contains(newId)) continue;
                this.ids.add(newId);
            }
        }
        if (updateParents && this.feature.isContainment() && (model = this.parent.giGetResource()) != null) {
            for (Long l : this.ids) {
                element = model.getObject(l);
                this.setParent(element);
            }
        }
        if (requiresNotify) {
            this.notify(oldIds, newIds);
        }
    }

    protected boolean notifyFeatureChange() {
        return this.parent.notifyFeatureChange(this.feature);
    }

    protected synchronized void notify(List<Long> oldValue, List<Long> newValue) {
        if (this.parent == null) {
            return;
        }
        if (oldValue.equals(newValue)) {
            return;
        }
        ((AElementImpl)this.parent).giNotify(this.feature, oldValue, newValue);
    }

    protected synchronized void validateElementToAdd(IElement element) {
        if (element == null) {
            return;
        }
        if (this.parent == element) {
            throw new RuntimeException("list feature: element cannot contain itself");
        }
        IbeeResource resource = this.parent.giGetResource();
        if (resource == null) {
            if (this.autoResourceManagement) {
                resource = ResourceFactory.getInstance().createIbeeResource();
                resource.putObject(this.parent);
                resource.setRoot(this.parent);
            } else {
                throw new RuntimeException("element '" + this.parent.giGetElementType().getName() + "' is not in a resource");
            }
        }
        if (element.giGetResource() != null && element.giGetResource() != resource) {
            if (this.autoResourceManagement && element.giGetResource().getRoot() == element) {
                ResourceImporter importer = new ResourceImporter(resource);
                importer.setMode(ResourceImporter.Mode.Move);
                importer.importElements(element.giGetResource().getAllObjects());
            } else {
                throw new RuntimeException("element '" + element.giGetElementType().getName() + "' is contained in a different resource");
            }
        }
        if (element.giGetResource() == null && !this.feature.isContainment()) {
            throw new RuntimeException("element '" + element.giGetElementType().getName() + "' is not contained in a resource");
        }
        if (this.parent.isProtected(this.getFeature())) {
            throw new LockedElementException(this.parent);
        }
    }

    protected synchronized void addElementToResource(IElement element) {
        if (this.feature.isContainment()) {
            IElement currentParent = element.giGetParent();
            if (currentParent != null && currentParent != this.parent) {
                throw new RuntimeException("element " + element.giGetElementType().getName() + " has already another parent");
            }
            if (element.giGetResource() == null) {
                IbeeResource resource = this.parent.giGetResource();
                resource.putObject(element);
            }
        }
    }

    @Override
    public synchronized IListFeature<T> getFeature() {
        return this.feature;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            List<T> itIds;
            Iterator<T> internalIterator;
            {
                this.itIds = ListHandleImpl.this.getElements();
                this.internalIterator = this.itIds.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.internalIterator.hasNext();
            }

            @Override
            public T next() {
                return (IElement)this.internalIterator.next();
            }
        };
    }

    @Override
    public boolean remove(Object arg0) {
        this.removeElement((IElement)arg0);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int cnt = 0;
        IbeeResource model = this.parent.giGetResource();
        if (model == null) {
            return cnt;
        }
        if (this.ids != null) {
            for (long id : this.ids) {
                IElement element = model.getObject(id);
                if (element == null) continue;
                ++cnt;
            }
        }
        return cnt;
    }

    @Override
    public Object[] toArray() {
        return this.getElements().toArray();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (this.ids != null && o instanceof IElement) {
            Long id = ((IElement)o).giGetElementId();
            return this.ids.contains(id);
        }
        return false;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getElements().toArray(a);
    }

    @Override
    public boolean add(T e) {
        this.addElement(e);
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getElements().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.addElements(c);
        return true;
    }

    @Override
    public void clear() {
        this.clearElements();
    }
}

