/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.iml.model.impl;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.IOrderedListHandle;
import net.edgemind.ibee.core.iml.model.impl.ListHandleImpl;
import net.edgemind.ibee.core.resource.IbeeResource;

public class OrderedListHandleImpl<T extends IElement>
extends ListHandleImpl<T>
implements IOrderedListHandle<T> {
    private static final long serialVersionUID = 1L;

    public OrderedListHandleImpl(IElement parent, IListFeature<T> feature) {
        super(parent, feature);
    }

    @Override
    public synchronized T getElement(int index) {
        if (this.ids == null) {
            return null;
        }
        IbeeResource model = this.parent.giGetResource();
        if (model == null) {
            return null;
        }
        if (index >= this.ids.size()) {
            return null;
        }
        return (T)model.getObject((Long)((List)this.ids).get(index));
    }

    @Override
    public synchronized T addElement(T element, int index) {
        return super.addElementByIndex(element, index);
    }

    @Override
    protected void insertId(long id, int index) {
        if (this.ids == null) {
            this.ids = this.createList();
        }
        if (index >= 0) {
            ((List)this.ids).add(index, id);
        } else {
            this.ids.add(id);
        }
    }

    @Override
    public void sort(final Comparator<? super T> comparator) {
        if (this.ids == null) {
            return;
        }
        final IbeeResource model = this.parent.giGetResource();
        if (model == null) {
            return;
        }
        ((List)this.ids).sort(new Comparator<Long>(){

            @Override
            public int compare(Long id1, Long id2) {
                IElement e1 = model.getObject(id1);
                IElement e2 = model.getObject(id2);
                if (e1 == null) {
                    return 0;
                }
                if (e2 == null) {
                    return 0;
                }
                return comparator.compare(e1, e2);
            }
        });
    }

    @Override
    public int lastIndexOf(Object arg0) {
        return this.getElements().lastIndexOf(arg0);
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator(int arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int index) {
        T o = this.getElement(index);
        if (o != null) {
            this.removeElement((IElement)o);
        }
        return o;
    }

    @Override
    public T set(int index, T element) {
        return this.addElement(element, index);
    }

    @Override
    public List<T> subList(int arg0, int arg1) {
        return this.getElements().subList(arg0, arg1);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        this.addElements(c);
        return true;
    }

    @Override
    public T get(int index) {
        return (T)((IElement)this.getElements().get(index));
    }

    @Override
    public void add(int index, T element) {
        Collection list = this.getElements();
        list.add(index, element);
        this.setElements(list);
    }

    @Override
    public int indexOf(Object o) {
        return this.getElements().indexOf(o);
    }

    @Override
    protected Collection<Long> createList() {
        return new LongArrayList();
    }
}

