/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.iml.modules.base.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.edgemind.ibee.core.iml.ImfModelException;
import net.edgemind.ibee.core.iml.domain.Domain;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.modules.base.IBaseDomain;
import net.edgemind.ibee.core.iml.modules.base.IBaseModel;
import net.edgemind.ibee.core.iml.modules.base.IIncludeFilter;
import net.edgemind.ibee.core.iml.modules.base.ILockable;
import net.edgemind.ibee.core.iml.modules.base.IModelInclude;
import net.edgemind.ibee.core.iml.modules.base.impl.BaseModelImpl;
import net.edgemind.ibee.core.iml.modules.base.impl.IncludeFilterImpl;
import net.edgemind.ibee.core.iml.modules.base.impl.LockableImpl;
import net.edgemind.ibee.core.iml.modules.base.impl.ModelIncludeImpl;

public class BaseDomainImpl
extends Domain
implements IBaseDomain {
    protected Map<IElementType<?>, Supplier<IElement>> creators = new HashMap();
    protected static boolean initialized = false;

    public BaseDomainImpl() {
        super("base");
        super.setVersion("");
        this.creators.put(IModelInclude.type, () -> this.createModelInclude());
        this.creators.put(IIncludeFilter.type, () -> this.createIncludeFilter());
    }

    @Override
    public <T extends IElement> T create(IElementType<T> type) {
        if (type.isAbstract()) {
            throw new ImfModelException("Cannot create abstract type '" + type.getName() + "'");
        }
        Supplier<IElement> fct = this.creators.get(type);
        if (fct != null) {
            return (T)fct.get();
        }
        return null;
    }

    @Override
    public IIncludeFilter createIncludeFilter() {
        IncludeFilterImpl element = new IncludeFilterImpl();
        return element;
    }

    @Override
    public IModelInclude createModelInclude() {
        ModelIncludeImpl element = new ModelIncludeImpl();
        return element;
    }

    @Override
    public void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        BaseModelImpl.init(this);
        ModelIncludeImpl.init(this);
        IncludeFilterImpl.init(this);
        LockableImpl.init(this);
        super.add(IBaseModel.type);
        super.add(IModelInclude.type);
        super.add(IIncludeFilter.type);
        super.add(ILockable.type);
        super.finalizeInit();
    }
}

