/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.iml.modules.base.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.iml.ManualCodeBegin;
import net.edgemind.ibee.core.iml.ManualCodeEnd;
import net.edgemind.ibee.core.iml.domain.IDomain;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.domain.impl.ElementTypeImpl;
import net.edgemind.ibee.core.iml.domain.impl.ListFeatureImpl;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.ImfModel;
import net.edgemind.ibee.core.iml.model.impl.ImfModelImpl;
import net.edgemind.ibee.core.iml.modules.base.IBaseModel;
import net.edgemind.ibee.core.iml.modules.base.IIncludeFilter;
import net.edgemind.ibee.core.iml.modules.base.IModelInclude;
import net.edgemind.ibee.core.iml.modules.base.IncludeFilterType;
import net.edgemind.ibee.core.iml.modules.base.impl.ModelIncludeImpl;
import net.edgemind.ibee.core.library.IbeeLibrary;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.util.misc.IFilter;
import net.edgemind.ibee.util.string.PatternUtil;

public abstract class BaseModelImpl
extends ImfModelImpl
implements IBaseModel {
    public static final long serialVersionUID = 1L;

    @ManualCodeBegin
    private boolean isIncluded(IElement e, IModelInclude modelInclude) {
        if (modelInclude.getFilter().size() == 0) {
            return true;
        }
        boolean included = false;
        for (IIncludeFilter filter : modelInclude.getFilter()) {
            String expression = filter.getExpression();
            String[] exprList = expression.split(",");
            boolean filterApplies = true;
            String[] stringArray = exprList;
            int n = exprList.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                int index = s.indexOf("=");
                if (index >= 0) {
                    String key = s.substring(0, index);
                    String patternValue = s.substring(index + 1);
                    String compareValue = "";
                    if (key.equals("__type")) {
                        compareValue = e.giGetElementType().getName();
                    } else if (e.giGetElementType().hasAttributeFeature(key)) {
                        compareValue = e.giGetAttribute(key);
                    }
                    if (!PatternUtil.wildCardMatch((String)compareValue, (String)patternValue)) {
                        filterApplies = false;
                    }
                }
                ++n2;
            }
            if (!filterApplies) continue;
            boolean bl = included = filter.getType() == IncludeFilterType.INCLUDE;
        }
        return included;
    }

    @Override
    public <T extends IElement> Collection<T> getModelElements(IElementType<T> type, boolean withInherited, boolean withIncludes, IFilter<T> filter) {
        HashSet<T> finalSet = new HashSet<T>();
        finalSet.addAll(this.giGetResource().getGlobalElements(type, false, withInherited, e -> {
            if (e.getModel() != this) {
                return false;
            }
            return filter == null || filter.accept(e);
        }));
        if (withIncludes) {
            for (IModelInclude nextInclude : this.getIncludes()) {
                IbeeResource resource;
                String name = nextInclude.getName();
                IbeeLibrary library = this.giGetResource().getLibraryByName(name);
                if (library == null || (resource = library.getResource()) == null) continue;
                finalSet.addAll(resource.getGlobalElements(type, withInherited, false, e -> {
                    if (!this.isIncluded((IElement)e, nextInclude)) {
                        return false;
                    }
                    return filter == null || filter.accept(e);
                }));
            }
        }
        return finalSet;
    }

    @Override
    @ManualCodeEnd
    public IModelInclude addInclude(IModelInclude element) {
        return super.giGetList(includesFeature).addElement(element);
    }

    public BaseModelImpl() {
        super((IElementType<? extends ImfModel>)IBaseModel.type);
    }

    public BaseModelImpl(IElementType<? extends IBaseModel> type) {
        super((IElementType<? extends ImfModel>)type);
    }

    @Override
    public void clearIncludes() {
        super.giGetList(includesFeature).clearElements();
    }

    @Override
    public IModelInclude createInclude() {
        IbeeResource resource = this.giGetResource();
        if (resource == null) {
            throw new IbeeException("Cannot create child list element: Element not in a resource");
        }
        ModelIncludeImpl var = new ModelIncludeImpl();
        this.addInclude(var);
        return var;
    }

    @Override
    public List<IModelInclude> getIncludes() {
        return (List)((Object)super.giGetList(includesFeature));
    }

    protected static void init(IDomain domain) {
        ((ElementTypeImpl)((Object)IBaseModel.type)).setAbstract(true);
        ((ElementTypeImpl)((Object)IBaseModel.type)).setDescription("");
        ((ElementTypeImpl)((Object)IBaseModel.type)).setDomain(domain);
        ((ElementTypeImpl)((Object)IBaseModel.type)).setGlobal(false);
        ((ElementTypeImpl)((Object)IBaseModel.type)).addList(includesFeature);
        ((ListFeatureImpl)includesFeature).isContainment(true);
        ((ListFeatureImpl)includesFeature).isContainer(false);
        ((ListFeatureImpl)includesFeature).isOrdered(true);
        ((ListFeatureImpl)includesFeature).addType(IModelInclude.type);
        ((ListFeatureImpl)includesFeature).isRequired(false);
        ((ListFeatureImpl)includesFeature).isKey(false);
    }

    @Override
    public void removeInclude(IModelInclude element) {
        super.giGetList(includesFeature).removeElement(element);
    }
}

