/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import net.edgemind.ibee.core.log.ILogHandler;
import net.edgemind.ibee.core.log.LogLevel;

public class StreamReader
extends Thread {
    private BufferedReader in;
    private ILogHandler handler;
    private LogLevel logLevel = LogLevel.INFO;

    public void setHandler(ILogHandler handler) {
        this.handler = handler;
    }

    public void setLogLevel(LogLevel level) {
        this.logLevel = level;
    }

    public StreamReader(InputStream in, String encoding) {
        this(in, Charset.forName(encoding));
    }

    public StreamReader(InputStream in, Charset encoding) {
        this.in = new BufferedReader(new InputStreamReader(in, encoding));
    }

    @Override
    public void run() {
        try {
            String s;
            StringBuilder msg = new StringBuilder();
            while ((s = this.in.readLine()) != null) {
                if (msg.length() > 0) {
                    msg.append("\n");
                }
                msg.append(s);
                if (this.in.ready()) continue;
                this.handler.log(msg.toString(), this.logLevel);
                msg = new StringBuilder();
            }
        }
        catch (IOException e) {
            this.handler.log(e);
        }
    }
}

