/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.library;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.impl.AElementImpl;
import net.edgemind.ibee.core.iml.model.impl.ElementHandleImpl;
import net.edgemind.ibee.core.iml.model.impl.ListHandleImpl;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.core.log.LogUtil;

public class IbeeLibraryEntry {
    private Map<Long, IElement> map = new HashMap<Long, IElement>();
    private long nextId = 0L;
    private boolean modified;
    private String sid;
    private IElement root;

    public void clear() {
        this.map.clear();
        this.nextId = 0L;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public String getSid() {
        return this.sid;
    }

    public synchronized Collection<IElement> getAllObjects() {
        return this.map.values();
    }

    public IElement getRoot() {
        return this.root;
    }

    public IElement getObject(long id) {
        return this.map.get(id);
    }

    public void setRoot(IElement root) {
        if (!this.map.containsKey(root.giGetElementId())) {
            this.putObject(root);
        }
        this.root = root;
    }

    public synchronized void putObject(IElement element) {
        if (this.map == null) {
            this.map = new HashMap<Long, IElement>();
        }
        if (element == null) {
            return;
        }
        if (element.giGetElementId() == -1L) {
            long elementId = this.getNextId();
            ((AElementImpl)element).giSetId(elementId);
        } else {
            long elementId = element.giGetElementId();
            if (elementId > this.nextId) {
                this.nextId = elementId;
            }
        }
        this.map.put(element.giGetElementId(), element);
    }

    public synchronized List<IElement> purge() {
        LogUtil.log("purge library", LogLevel.DEBUG);
        HashSet keep = new HashSet();
        ArrayList<IElement> toPurge = new ArrayList<IElement>();
        for (IElement element : this.map.values()) {
            if (keep.contains(element)) continue;
            toPurge.add(element);
        }
        for (IElement element : toPurge) {
            this.map.remove(element.giGetElementId());
        }
        for (IElement element : this.map.values()) {
            for (IListFeature<IElement> iListFeature : element.giGetElementType().getListFeatures()) {
                boolean modified = false;
                List<Long> ids = ((ListHandleImpl)element.giGetList(iListFeature)).getAllElementIds();
                ArrayList<Long> newIds = null;
                for (Long id : ids) {
                    if (this.map.containsKey(id)) {
                        if (newIds == null) {
                            newIds = new ArrayList<Long>();
                        }
                        newIds.add(id);
                        continue;
                    }
                    modified = true;
                }
                if (!modified) continue;
                ((AElementImpl)element).giNotify(iListFeature, ids, newIds);
            }
            for (IElementFeature iElementFeature : element.giGetElementType().getElementFeatures()) {
                Long id = ((ElementHandleImpl)element.giGetElement(iElementFeature)).getElementId();
                if (id == -1L || this.map.containsKey(id)) continue;
                ((AElementImpl)element).giNotify(iElementFeature, id, -1L);
            }
        }
        return toPurge;
    }

    private synchronized long getNextId() {
        ++this.nextId;
        while (this.map.containsKey(this.nextId)) {
            ++this.nextId;
        }
        return this.nextId;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean value) {
        this.modified = value;
    }
}

