/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.library;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.impl.ElementHandleImpl;
import net.edgemind.ibee.core.iml.model.impl.ListHandleImpl;
import net.edgemind.ibee.core.library.IbeeLibrary;
import net.edgemind.ibee.core.library.IbeeLibraryEntry;

public class LibraryImporter {
    private IbeeLibrary library;
    private Map<Long, Long> importMap = new HashMap<Long, Long>();
    private boolean removeUnresolvedReferences = false;

    public LibraryImporter(IbeeLibrary library) {
        this.library = library;
    }

    public void setRemoveUnresolvedReferences(boolean value) {
        this.removeUnresolvedReferences = value;
    }

    public void reset() {
        this.importMap.clear();
    }

    public synchronized IElement importIntoLibrary(IElement root, String sid) {
        this.importMap.clear();
        IbeeLibraryEntry entry = this.library.getEntry(sid, true);
        entry.clear();
        ArrayList<IElement> elements = new ArrayList<IElement>();
        this.collectElements(root, elements);
        Map<Long, Long> map = this.importIntoLibrary(elements, sid);
        IElement importedRoot = entry.getObject(map.get(root.giGetElementId()));
        entry.setRoot(importedRoot);
        return null;
    }

    private void collectElements(IElement element, Collection<IElement> elements) {
        elements.add(element);
        for (IListFeature<IElement> iListFeature : element.giGetElementType().getListFeatures()) {
            if (!iListFeature.isContainment()) continue;
            for (IElement iElement : element.giGetList(iListFeature).getElements()) {
                this.collectElements(iElement, elements);
            }
        }
        for (IElementFeature iElementFeature : element.giGetElementType().getElementFeatures()) {
            Object t;
            if (!iElementFeature.isContainment() || (t = element.giGetElement(iElementFeature).getElement()) == null) continue;
            this.collectElements((IElement)t, elements);
        }
    }

    private synchronized Map<Long, Long> importIntoLibrary(Collection<IElement> elements, String sid) {
        IbeeLibraryEntry entry = this.library.getEntry(sid, true);
        for (IElement element : elements) {
            IElement clone;
            Long importedId = this.importMap.get(element.giGetElementId());
            if (importedId == null) {
                clone = element.giGetElementType().getDomain().create(element.giGetElementType());
                entry.putObject(clone);
                this.importMap.put(element.giGetElementId(), clone.giGetElementId());
                continue;
            }
            clone = entry.getObject(importedId);
            clone.clear();
        }
        Iterator<IElement> iterator = elements.iterator();
        while (iterator.hasNext()) {
            IElement element;
            IElement elementToImport = element = iterator.next();
            Long idToImport = this.importMap.get(elementToImport.giGetElementId());
            IElement clone = entry.getObject(idToImport);
            for (IAttributeFeature iAttributeFeature : elementToImport.giGetElementType().getAttributeFeatures()) {
                String value = elementToImport.giGetAttribute(iAttributeFeature);
                clone.giSetAttribute(iAttributeFeature, value);
            }
            for (IListFeature iListFeature : elementToImport.giGetElementType().getListFeatures()) {
                ArrayList<Long> ids = new ArrayList<Long>();
                for (Long id : ((ListHandleImpl)elementToImport.giGetList(iListFeature)).getAllElementIds()) {
                    Long importedId = this.importMap.get(id);
                    if (importedId != null) {
                        ids.add(importedId);
                        continue;
                    }
                    if (this.removeUnresolvedReferences) continue;
                    throw new IbeeException("library currupt, element id " + String.valueOf(id) + "not known");
                }
                if (ids.size() <= 0) continue;
                ((ListHandleImpl)clone.giGetList(iListFeature)).setAllElementsByIdInject(ids, false);
            }
            for (IElementFeature iElementFeature : elementToImport.giGetElementType().getElementFeatures()) {
                Long id = ((ElementHandleImpl)elementToImport.giGetElement(iElementFeature)).getElementId();
                if (id == null || id < 0L) continue;
                Long importedId = this.importMap.get(id);
                if (importedId != null) {
                    ((ElementHandleImpl)clone.giGetElement(iElementFeature)).setElementByIdInject(importedId, false);
                    continue;
                }
                if (this.removeUnresolvedReferences) continue;
                throw new IbeeException("library currupt, element id " + String.valueOf(id) + "not known");
            }
        }
        return this.importMap;
    }
}

