/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.log;

import net.edgemind.ibee.core.context.ContextStack;
import net.edgemind.ibee.core.log.ILogHandler;
import net.edgemind.ibee.core.log.ILogable;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.core.log.NullLogHandler;
import net.edgemind.ibee.util.string.StringUtil;

public class ALogable
implements ILogable {
    private ILogHandler logHandler;
    private static ILogHandler defaultLogHandler = null;

    @Override
    public void setLogHandler(ILogHandler logHandler) {
        this.logHandler = logHandler;
    }

    public static void setDefaultLogHandler(ILogHandler logHandler) {
        defaultLogHandler = logHandler;
    }

    @Override
    public ILogHandler getLogHandler() {
        ILogHandler logHandler = this.logHandler;
        if (logHandler == null) {
            logHandler = ContextStack.getCurrentContextValue(ILogHandler.class);
        }
        if (logHandler == null) {
            logHandler = defaultLogHandler;
        }
        if (logHandler == null) {
            logHandler = new NullLogHandler();
        }
        return logHandler;
    }

    @Override
    public void log(String msg) {
        this.log(msg, LogLevel.INFO);
    }

    @Override
    public void log(String msg, LogLevel level) {
        ILogHandler logHandler = this.getLogHandler();
        if (logHandler != null && !StringUtil.isNullOrEmpty((String)msg)) {
            logHandler.log(msg, level);
        }
    }

    @Override
    public void log(Throwable e, LogLevel level) {
        ILogHandler logHandler = this.getLogHandler();
        if (logHandler != null) {
            this.getLogHandler().log(e, level);
        }
    }

    @Override
    public void error(Throwable e) {
        this.log(e, LogLevel.ERROR);
    }

    @Override
    public void error(String msg) {
        this.log(msg, LogLevel.ERROR);
    }

    @Override
    public void warn(String msg) {
        this.log(msg, LogLevel.WARNING);
    }

    @Override
    public void info(String msg) {
        this.log(msg, LogLevel.INFO);
    }

    @Override
    public void debug(String msg) {
        this.log(msg, LogLevel.DEBUG);
    }

    @Override
    public void log(Throwable e) {
        this.log(e, LogLevel.ERROR);
    }
}

