/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.log;

import java.util.Date;
import java.util.function.Function;
import net.edgemind.ibee.core.log.ALogHandler;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.util.Tuple;

public class ConsoleLogHandler
extends ALogHandler {
    private Function<Tuple<String, LogLevel>, String> messageCreator = logEntry -> String.format("[%s,%s] %s", ((LogLevel)((Object)((Object)logEntry.second))).toString(), new Date().toString(), logEntry.first);

    public ConsoleLogHandler() {
        super.setName("ConsoleLogHandler");
    }

    public Function<Tuple<String, LogLevel>, String> getMessageCreator() {
        return this.messageCreator;
    }

    public ConsoleLogHandler setMessageCreator(Function<Tuple<String, LogLevel>, String> messageCreator) {
        this.messageCreator = messageCreator;
        return this;
    }

    @Override
    public void log(String msg, LogLevel level) {
        String msg2 = this.messageCreator.apply((Tuple<String, LogLevel>)new Tuple((Object)msg, (Object)level));
        if (level == LogLevel.ERROR) {
            System.err.println(msg2);
        } else {
            System.out.println(msg2);
        }
    }

    @Override
    public void log(Throwable e) {
        e.printStackTrace();
    }
}

