/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.log;

import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.function.Function;
import net.edgemind.ibee.core.log.ALogHandler;
import net.edgemind.ibee.core.log.ILogHandler;
import net.edgemind.ibee.core.log.LogEntry;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.util.file.FileUtil;

public class FileLogHandler
extends ALogHandler
implements ILogHandler,
Closeable,
Flushable {
    private Writer writer;
    private File logFile;
    private boolean autoFlush;
    private final Object lock = new Object();
    private Function<LogEntry, String> messageCreator = logEntry -> String.format("[%s,%s] %s", logEntry.getLevel().toString(), new Date().toString(), logEntry.getMessage());

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public void setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
    }

    public FileLogHandler(File file) throws IOException {
        FileUtil.createDir((File)file.getParentFile());
        this.writer = FileUtil.openWriter((File)file, (Charset)Charset.forName("UTF-8"));
        this.writer.flush();
    }

    public File getLogFile() {
        return this.logFile;
    }

    public Function<LogEntry, String> getMessageCreator() {
        return this.messageCreator;
    }

    public void setMessageCreator(Function<LogEntry, String> messageCreator) {
        this.messageCreator = messageCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.writer != null) {
                this.writer.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.writer != null) {
                    this.writer.close();
                }
            }
            finally {
                this.writer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(String msg, LogLevel level) {
        if (msg == null) {
            return;
        }
        String msg2 = this.messageCreator.apply(new LogEntry(msg, level));
        if (msg2 == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.writer != null) {
                try {
                    this.writer.write(msg2);
                    this.writer.write(FileUtil.lineSeparator());
                    if (this.autoFlush) {
                        this.flush();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

