/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.log;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.edgemind.ibee.core.log.ALogHandler;
import net.edgemind.ibee.core.log.LogEntry;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.util.misc.IFilter;

public class LogRecorder
extends ALogHandler {
    private List<LogEntry> logBuffer = new LinkedList<LogEntry>();
    private final Object lock = new Object();

    public List<LogEntry> getLogBuffer() {
        return this.logBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogBuffer(List<LogEntry> logBuffer) {
        Object object = this.lock;
        synchronized (object) {
            this.logBuffer = logBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(String msg, LogLevel level) {
        Object object = this.lock;
        synchronized (object) {
            LogEntry entry = new LogEntry(msg, level);
            this.logBuffer.add(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogEntry> getAllLogs() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<LogEntry>(this.logBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.logBuffer.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogEntry> getLogs(int fromIndex, int toIndex) {
        Object object = this.lock;
        synchronized (object) {
            toIndex = Math.min(this.logBuffer.size(), toIndex);
            return new ArrayList<LogEntry>(this.logBuffer.subList(fromIndex, toIndex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogEntry> findLogs(IFilter<LogEntry> filter) {
        Object object = this.lock;
        synchronized (object) {
            return this.logBuffer.stream().filter(entry -> filter == null || filter.accept(entry)).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.logBuffer.clear();
        }
    }
}

